/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.collections.MapBuilder;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="HiddenFieldCheck", repositoryKey="squid")
@Rule(key="S1117")
public class HiddenFieldCheck
extends IssuableSubscriptionVisitor {
    private final Deque<Map<String, VariableTree>> fields = new LinkedList<Map<String, VariableTree>>();
    private final Deque<List<VariableTree>> excludedVariables = new LinkedList<List<VariableTree>>();
    private final List<VariableTree> flattenExcludedVariables = new ArrayList<VariableTree>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.RECORD, Tree.Kind.VARIABLE, Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR, Tree.Kind.STATIC_INITIALIZER);
    }

    public void setContext(JavaFileScannerContext context) {
        this.fields.clear();
        this.excludedVariables.clear();
        this.flattenExcludedVariables.clear();
        super.setContext(context);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        if (HiddenFieldCheck.isClassTree(tree)) {
            ClassTree classTree = (ClassTree)tree;
            MapBuilder builder = MapBuilder.newMap();
            for (Tree member : classTree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
                VariableTree variableTree = (VariableTree)member;
                builder.put((Object)variableTree.simpleName().name(), (Object)variableTree);
            }
            this.fields.push(builder.build());
            this.excludedVariables.push(new ArrayList());
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            VariableTree variableTree = (VariableTree)tree;
            this.isVariableHidingField(variableTree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.STATIC_INITIALIZER})) {
            this.excludeVariablesFromBlock((BlockTree)tree);
        } else {
            MethodTree methodTree = (MethodTree)tree;
            this.excludedVariables.peek().addAll(methodTree.parameters());
            this.flattenExcludedVariables.addAll(methodTree.parameters());
            if (ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.STATIC)) {
                this.excludeVariablesFromBlock(methodTree.block());
            }
        }
    }

    private void isVariableHidingField(VariableTree variableTree) {
        for (Map<String, VariableTree> variables : this.fields) {
            if (variables.values().contains(variableTree)) {
                return;
            }
            String identifier = variableTree.simpleName().name();
            VariableTree hiddenVariable = variables.get(identifier);
            if (this.flattenExcludedVariables.contains(variableTree) || hiddenVariable == null || HiddenFieldCheck.isInStaticInnerClass(hiddenVariable, variableTree)) continue;
            int line = hiddenVariable.firstToken().line();
            this.reportIssue((Tree)variableTree.simpleName(), "Rename \"" + identifier + "\" which hides the field declared at line " + line + ".");
            return;
        }
    }

    private static boolean isInStaticInnerClass(VariableTree hiddenVariable, VariableTree variableTree) {
        Symbol hiddenVariableOwner = hiddenVariable.symbol().owner();
        for (Symbol owner = variableTree.symbol().owner(); owner != null && !owner.equals(hiddenVariableOwner); owner = owner.owner()) {
            if (!owner.isTypeSymbol() || !owner.isStatic()) continue;
            return true;
        }
        return false;
    }

    private static boolean isClassTree(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.RECORD});
    }

    public void leaveNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        if (HiddenFieldCheck.isClassTree(tree)) {
            this.fields.pop();
            this.flattenExcludedVariables.removeAll((Collection)this.excludedVariables.pop());
        }
    }

    private void excludeVariablesFromBlock(@Nullable BlockTree blockTree) {
        if (blockTree != null) {
            List<VariableTree> variableTrees = new VariableList().scan((Tree)blockTree);
            this.excludedVariables.peek().addAll(variableTrees);
            this.flattenExcludedVariables.addAll(variableTrees);
        }
    }

    private static class VariableList {
        private List<VariableTree> variables;
        private List<Tree.Kind> visitNodes;
        private List<Tree.Kind> excludedNodes;

        private VariableList() {
        }

        List<VariableTree> scan(Tree tree) {
            this.visitNodes = this.nodesToVisit();
            this.excludedNodes = this.excludedNodes();
            this.variables = new ArrayList<VariableTree>();
            this.visit(tree);
            return this.variables;
        }

        public List<Tree.Kind> nodesToVisit() {
            return Collections.singletonList(Tree.Kind.VARIABLE);
        }

        public List<Tree.Kind> excludedNodes() {
            return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.NEW_CLASS);
        }

        private void visit(Tree tree) {
            if (this.isSubscribed(tree)) {
                this.variables.add((VariableTree)tree);
            }
            this.visitChildren(tree);
        }

        private void visitChildren(Tree tree) {
            JavaTree javaTree = (JavaTree)tree;
            if (!javaTree.isLeaf()) {
                for (Tree next : javaTree.getChildren()) {
                    if (next == null || this.isExcluded(next)) continue;
                    this.visit(next);
                }
            }
        }

        private boolean isSubscribed(Tree tree) {
            return this.visitNodes.contains(tree.kind());
        }

        private boolean isExcluded(Tree tree) {
            return this.excludedNodes.contains(tree.kind());
        }
    }
}

