/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4544")
public class JacksonDeserializationCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers ENABLE_DEFAULT_TYPING = MethodMatchers.create().ofTypes(new String[]{"com.fasterxml.jackson.databind.ObjectMapper", "org.codehaus.jackson.map.ObjectMapper"}).names(new String[]{"enableDefaultTyping"}).addWithoutParametersMatcher().build();
    private static final String MESSAGE = "Make sure using this Jackson deserialization configuration is safe here.";

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.ANNOTATION);
    }

    public void visitNode(Tree tree) {
        AnnotationTree annotationTree;
        if (!this.hasSemantic()) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && ENABLE_DEFAULT_TYPING.matches((MethodInvocationTree)tree)) {
            this.reportIssue(tree, MESSAGE);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.ANNOTATION}) && JacksonDeserializationCheck.isJsonTypeInfo(annotationTree = (AnnotationTree)tree) && JacksonDeserializationCheck.isAnnotationOnClassOrField(annotationTree)) {
            JacksonDeserializationCheck.findUseArgument(annotationTree).ifPresent(useAnnotationArgument -> this.reportIssue((Tree)useAnnotationArgument, MESSAGE));
        }
    }

    private static boolean isJsonTypeInfo(AnnotationTree annotationTree) {
        Type annotationType = annotationTree.annotationType().symbolType();
        return annotationType.is("com.fasterxml.jackson.annotation.JsonTypeInfo") || annotationType.is("org.codehaus.jackson.annotate.JsonTypeInfo");
    }

    private static boolean isAnnotationOnClassOrField(AnnotationTree annotationTree) {
        if (annotationTree.parent().is(new Tree.Kind[]{Tree.Kind.MODIFIERS})) {
            Tree modifiers = annotationTree.parent();
            return modifiers.parent().is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.VARIABLE});
        }
        return false;
    }

    private static Optional<ExpressionTree> findUseArgument(AnnotationTree annotationTree) {
        for (ExpressionTree tree : annotationTree.arguments()) {
            AssignmentExpressionTree assignment;
            if (!tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) || !((IdentifierTree)(assignment = (AssignmentExpressionTree)tree).variable()).name().equals("use") || !JacksonDeserializationCheck.isJsonTypeIdEnumValue(assignment.expression())) continue;
            return Optional.of(assignment.expression());
        }
        return Optional.empty();
    }

    private static boolean isJsonTypeIdEnumValue(ExpressionTree tree) {
        if (!JacksonDeserializationCheck.isJsonTypeId(tree)) {
            return false;
        }
        String valueName = tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) ? ((MemberSelectExpressionTree)tree).identifier().name() : ((IdentifierTree)tree).name();
        return valueName.equals("CLASS") || valueName.equals("MINIMAL_CLASS");
    }

    private static boolean isJsonTypeId(ExpressionTree tree) {
        Type type = tree.symbolType();
        return type.is("com.fasterxml.jackson.annotation.JsonTypeInfo$Id") || type.is("org.codehaus.jackson.annotate.JsonTypeInfo$Id");
    }
}

