/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2653")
public class MainInServletCheck
extends IssuableSubscriptionVisitor {
    private static final List<String> SERVLET_AND_EJB_CLASSES = Arrays.asList("javax.servlet.http.HttpServlet", "org.apache.struts.action.Action", "javax.ejb.EnterpriseBean");

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree node = (ClassTree)tree;
        Symbol.TypeSymbol symbol = node.symbol();
        if (MainInServletCheck.isServletOrEjb((Symbol)symbol)) {
            for (Tree member : node.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD}) || !MethodTreeUtils.isMainMethod((MethodTree)member)) continue;
                this.reportIssue((Tree)((MethodTree)member).simpleName(), "Remove this unwanted \"main\" method.");
            }
        }
    }

    private static boolean isServletOrEjb(Symbol symbol) {
        if (SERVLET_AND_EJB_CLASSES.stream().anyMatch(arg_0 -> ((Type)symbol.type()).isSubtypeOf(arg_0))) {
            return true;
        }
        return symbol.metadata().annotations().stream().anyMatch(annotation -> annotation.symbol().type().fullyQualifiedName().startsWith("javax.ejb."));
    }
}

