/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractPrintfChecker;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3457")
public class PrintfMisuseCheck
extends AbstractPrintfChecker {
    private static final String ORG_SLF4J_LOGGER = "org.slf4j.Logger";
    private static final String JAVA_UTIL_LOGGING_LOGGER = "java.util.logging.Logger";
    private static final MethodMatchers TO_STRING = MethodMatchers.create().ofAnyType().names(new String[]{"toString"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers GET_LOGGER = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.util.logging.Logger"}).names(new String[]{"getLogger"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.String"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.util.logging.Logger"}).names(new String[]{"getAnonymousLogger"}).addParametersMatcher(new String[]{"java.lang.String"}).build()});
    private static final MethodMatchers JAVA_UTIL_LOGGER_LOG_LEVEL_STRING = MethodMatchers.create().ofTypes(new String[]{"java.util.logging.Logger"}).names(new String[]{"log"}).addParametersMatcher(new String[]{"java.util.logging.Level", "java.lang.String"}).build();
    private static final MethodMatchers JAVA_UTIL_LOGGER_LOG_LEVEL_STRING_ANY = MethodMatchers.create().ofTypes(new String[]{"java.util.logging.Logger"}).names(new String[]{"log"}).addParametersMatcher(new String[]{"java.util.logging.Level", "java.lang.String", "*"}).build();
    private static final MethodMatchers JAVA_UTIL_LOGGER_LOG_MATCHER = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{JAVA_UTIL_LOGGER_LOG_LEVEL_STRING, JAVA_UTIL_LOGGER_LOG_LEVEL_STRING_ANY});
    private static final MethodMatchers SLF4J_METHOD_MATCHERS = MethodMatchers.or(LEVELS.stream().map(l -> MethodMatchers.create().ofTypes(new String[]{ORG_SLF4J_LOGGER}).names(new String[]{l}).withAnyParameters().build()).collect(Collectors.toList()));

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        ArrayList<MethodMatchers> matchers = new ArrayList<MethodMatchers>();
        matchers.add(SLF4J_METHOD_MATCHERS);
        matchers.add(super.getMethodInvocationMatchers());
        matchers.add(PrintfMisuseCheck.log4jMethods());
        matchers.add(JAVA_UTIL_LOGGER_LOG_LEVEL_STRING);
        matchers.add(JAVA_UTIL_LOGGER_LOG_LEVEL_STRING_ANY);
        return MethodMatchers.or(matchers);
    }

    private static MethodMatchers log4jMethods() {
        ArrayList<String> methodNames = new ArrayList<String>();
        methodNames.add("printf");
        methodNames.add("log");
        methodNames.addAll(LEVELS);
        return MethodMatchers.create().ofTypes(new String[]{"org.apache.logging.log4j.Logger"}).names(methodNames.toArray(new String[0])).withAnyParameters().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        boolean isMessageFormat = MESSAGE_FORMAT.matches(mit);
        if (isMessageFormat && !mit.symbol().isStatic()) {
            return;
        }
        if (!isMessageFormat && JAVA_UTIL_LOGGER_LOG_MATCHER.matches(mit) && PrintfMisuseCheck.hasResourceBundle(mit)) {
            return;
        }
        if (!isMessageFormat) {
            isMessageFormat = JAVA_UTIL_LOGGER_LOG_LEVEL_STRING_ANY.matches(mit);
        }
        if (!isMessageFormat) {
            isMessageFormat = PrintfMisuseCheck.isLoggingMethod(mit);
        }
        super.checkFormatting(mit, isMessageFormat);
    }

    private static boolean hasResourceBundle(MethodInvocationTree mit) {
        VariableTree var;
        ExpressionTree init;
        Tree decl;
        if (!mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return false;
        }
        ExpressionTree id = ((MemberSelectExpressionTree)mit.methodSelect()).expression();
        if (id.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            id = ((MemberSelectExpressionTree)id).identifier();
        }
        if (id.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (decl = ((IdentifierTree)id).symbol().declaration()) != null && decl.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && (init = (var = (VariableTree)decl).initializer()) != null && init.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return GET_LOGGER.matches((MethodInvocationTree)init);
        }
        return false;
    }

    @Override
    protected void handlePrintfFormat(MethodInvocationTree mit, String formatString, List<ExpressionTree> args) {
        this.handlePrintfFormat(mit, formatString, args, false);
    }

    @Override
    protected void handlePrintfFormatCatchingErrors(MethodInvocationTree mit, String formatString, List<ExpressionTree> args) {
        this.handlePrintfFormat(mit, formatString, args, true);
    }

    private void handlePrintfFormat(MethodInvocationTree mit, String formatString, List<ExpressionTree> args, boolean catchErrors) {
        List<String> params = this.getParameters(formatString, mit);
        if (PrintfMisuseCheck.usesMessageFormat(formatString, params)) {
            this.reportIssue((Tree)mit, "Looks like there is a confusion with the use of java.text.MessageFormat, parameters will be simply ignored here");
            return;
        }
        this.checkLineFeed(formatString, mit);
        if (!(!params.isEmpty() || args.isEmpty() && PrintfMisuseCheck.isLoggingMethod(mit))) {
            this.reportIssue((Tree)mit, "String contains no format specifiers.");
            return;
        }
        PrintfMisuseCheck.cleanupLineSeparator(params);
        if (!params.isEmpty()) {
            if (PrintfMisuseCheck.argIndexes(params).size() <= args.size()) {
                this.verifyParametersForMisuse(mit, args, params);
            }
            if (catchErrors) {
                if (this.checkArgumentNumber(mit, PrintfMisuseCheck.argIndexes(params).size(), args.size())) {
                    return;
                }
                this.verifyParametersForErrors(mit, args, params);
            }
        }
    }

    private void verifyParametersForMisuse(MethodInvocationTree mit, List<ExpressionTree> args, List<String> params) {
        int index = 0;
        ArrayList<ExpressionTree> unusedArgs = new ArrayList<ExpressionTree>(args);
        Iterator<String> iterator = params.iterator();
        while (iterator.hasNext()) {
            String rawParam;
            String param = rawParam = iterator.next();
            int argIndex = index++;
            if (param.contains("$")) {
                argIndex = PrintfMisuseCheck.getIndex(param) - 1;
                if (argIndex == -1) {
                    this.reportIssue((Tree)mit, "Arguments are numbered starting from 1.");
                    return;
                }
                param = param.substring(param.indexOf(36) + 1);
            } else if (param.charAt(0) == '<') {
                argIndex = Math.max(0, argIndex - 1);
            }
            if (argIndex >= args.size()) {
                return;
            }
            ExpressionTree argExpressionTree = args.get(argIndex);
            unusedArgs.remove(argExpressionTree);
            Type argType = argExpressionTree.symbolType();
            this.checkBoolean(mit, param, argType);
        }
        this.reportUnusedArgs(mit, args, unusedArgs);
    }

    @Override
    protected void handleMessageFormat(MethodInvocationTree mit, String formatString, List<ExpressionTree> args) {
        String newFormatString = PrintfMisuseCheck.cleanupDoubleQuote(formatString);
        Set<Integer> indexes = PrintfMisuseCheck.getMessageFormatIndexes(newFormatString, mit);
        List<ExpressionTree> transposedArgs = PrintfMisuseCheck.transposeArgumentArrayAndRemoveThrowable(mit, args, indexes);
        if (transposedArgs == null) {
            return;
        }
        if (indexes.isEmpty() && !transposedArgs.isEmpty()) {
            this.reportIssue((Tree)mit, "String contains no format specifiers.");
            return;
        }
        if (this.checkArgumentNumber(mit, indexes.size(), transposedArgs.size()) || this.checkUnbalancedQuotes(mit, newFormatString)) {
            return;
        }
        this.checkToStringInvocation(transposedArgs);
        this.verifyParameters(mit, transposedArgs, indexes);
    }

    private boolean checkUnbalancedQuotes(MethodInvocationTree mit, String formatString) {
        boolean unbalancedQuotes;
        if (LEVELS.contains(mit.symbol().name())) {
            return false;
        }
        String withoutParam = MESSAGE_FORMAT_PATTERN.matcher(formatString).replaceAll("");
        int numberQuote = 0;
        for (int i = 0; i < withoutParam.length(); ++i) {
            if (withoutParam.charAt(i) != '\'') continue;
            ++numberQuote;
        }
        boolean bl = unbalancedQuotes = numberQuote % 2 != 0;
        if (unbalancedQuotes) {
            this.reportIssue((Tree)mit.arguments().get(0), "Single quote \"'\" must be escaped.");
        }
        return unbalancedQuotes;
    }

    @Nullable
    private static List<ExpressionTree> transposeArgumentArrayAndRemoveThrowable(MethodInvocationTree mit, List<ExpressionTree> args, Set<Integer> indexes) {
        return PrintfMisuseCheck.transposeArgumentArray(args).map(transposedArgs -> {
            if (PrintfMisuseCheck.lastArgumentShouldBeIgnored(mit, args, transposedArgs, indexes)) {
                return transposedArgs.subList(0, transposedArgs.size() - 1);
            }
            return transposedArgs;
        }).orElse(null);
    }

    private static boolean lastArgumentShouldBeIgnored(MethodInvocationTree mit, List<ExpressionTree> args, List<ExpressionTree> transposedArgs, Set<Integer> indexes) {
        if (!PrintfMisuseCheck.isLoggingMethod(mit)) {
            return false;
        }
        if (mit.symbol().owner().type().is(JAVA_UTIL_LOGGING_LOGGER)) {
            return args.size() == 1 && PrintfMisuseCheck.isLastArgumentThrowable(args);
        }
        if (transposedArgs.size() == 1) {
            return PrintfMisuseCheck.isLastArgumentThrowable(transposedArgs);
        }
        return transposedArgs.size() > indexes.size() && PrintfMisuseCheck.isLastArgumentThrowable(transposedArgs);
    }

    private static boolean isLastArgumentThrowable(List<ExpressionTree> arguments) {
        if (arguments.isEmpty()) {
            return false;
        }
        ExpressionTree lastArgument = arguments.get(arguments.size() - 1);
        if (lastArgument.symbolType().isSubtypeOf("java.lang.Throwable")) {
            return true;
        }
        return PrintfMisuseCheck.hasUnknownExceptionInUnionType(ExpressionUtils.skipParentheses((ExpressionTree)lastArgument));
    }

    private static boolean hasUnknownExceptionInUnionType(ExpressionTree lastArgument) {
        VariableTree declaration;
        if (!lastArgument.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return false;
        }
        Symbol symbol = ((IdentifierTree)lastArgument).symbol();
        VariableTree variableTree = declaration = symbol.isVariableSymbol() ? ((Symbol.VariableSymbol)symbol).declaration() : null;
        if (declaration == null) {
            return false;
        }
        TypeTree declarationType = declaration.type();
        return declarationType.is(new Tree.Kind[]{Tree.Kind.UNION_TYPE}) && ((UnionTypeTree)declarationType).typeAlternatives().stream().map(TypeTree::symbolType).anyMatch(Type::isUnknown);
    }

    private void checkToStringInvocation(List<ExpressionTree> args) {
        args.stream().filter(arg -> arg.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})).map(MethodInvocationTree.class::cast).filter(arg_0 -> ((MethodMatchers)TO_STRING).matches(arg_0)).filter(arg -> arg != args.get(args.size() - 1) || !PrintfMisuseCheck.isMethodOfThrowable(arg)).forEach(arg -> this.reportIssue((Tree)arg, PrintfMisuseCheck.getToStringMessage((ExpressionTree)arg)));
    }

    private static boolean isMethodOfThrowable(MethodInvocationTree argument) {
        Symbol owner = argument.symbol().owner();
        return owner != null && owner.type().isSubtypeOf("java.lang.Throwable");
    }

    private static String getToStringMessage(ExpressionTree arg) {
        if (PrintfMisuseCheck.isInStringArrayInitializer(arg)) {
            return "No need to call \"toString()\" method since an array of Objects can be used here.";
        }
        return "No need to call \"toString()\" method as formatting and string conversion is done by the Formatter.";
    }

    private static boolean isInStringArrayInitializer(ExpressionTree arg) {
        return Optional.of(arg).map(Tree::parent).filter(tree -> tree.is(new Tree.Kind[]{Tree.Kind.LIST})).map(Tree::parent).filter(tree -> tree.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})).map(NewArrayTree.class::cast).map(ExpressionTree::symbolType).filter(Type::isArray).map(Type.ArrayType.class::cast).map(Type.ArrayType::elementType).filter(type -> type.is("java.lang.String")).isPresent();
    }

    private void verifyParameters(MethodInvocationTree mit, List<ExpressionTree> args, Set<Integer> indexes) {
        ArrayList<ExpressionTree> unusedArgs = new ArrayList<ExpressionTree>(args);
        for (int index : indexes) {
            if (index >= args.size()) {
                this.reportIssue((Tree)mit, "Not enough arguments.");
                return;
            }
            unusedArgs.remove(args.get(index));
        }
        this.reportUnusedArgs(mit, args, unusedArgs);
    }

    private void reportUnusedArgs(MethodInvocationTree mit, List<ExpressionTree> args, List<ExpressionTree> unusedArgs) {
        for (ExpressionTree unusedArg : unusedArgs) {
            int i = args.indexOf(unusedArg);
            this.reportIssue((Tree)mit, PrintfMisuseCheck.postFixedIndex(i) + " argument is not used.");
        }
    }

    private static String postFixedIndex(int i) {
        if (i < 1) {
            return "first";
        }
        if (i < 2) {
            return "2nd";
        }
        if (i < 3) {
            return "3rd";
        }
        return i + 1 + "th";
    }

    private void checkBoolean(MethodInvocationTree mit, String param, Type argType) {
        if (param.charAt(0) == 'b' && !argType.is("boolean") && !argType.is("java.lang.Boolean")) {
            this.reportIssue((Tree)mit, "Directly inject the boolean value.");
        }
    }

    private void checkLineFeed(String formatString, MethodInvocationTree mit) {
        if (formatString.contains("\\n")) {
            this.reportIssue((Tree)mit, "%n should be used in place of \\n to produce the platform-specific line separator.");
        }
    }

    private static boolean usesMessageFormat(String formatString, List<String> params) {
        return params.isEmpty() && (formatString.contains("{0") || formatString.contains("{1"));
    }

    @Override
    protected void handleOtherFormatTree(MethodInvocationTree mit, ExpressionTree formatTree, List<ExpressionTree> args) {
        if (PrintfMisuseCheck.isIncorrectConcatenation(formatTree)) {
            boolean lastArgumentThrowable = PrintfMisuseCheck.isLastArgumentThrowable(args);
            if (JAVA_UTIL_LOGGER_LOG_MATCHER.matches(mit)) {
                if (lastArgumentThrowable) {
                    this.reportIssue((Tree)mit, "Lambda should be used to defer string concatenation.");
                } else {
                    this.reportIssue((Tree)mit, "Format specifiers or lambda should be used instead of string concatenation.");
                }
            } else if (!lastArgumentThrowable || !SLF4J_METHOD_MATCHERS.matches(mit)) {
                this.reportIssue((Tree)mit, "Format specifiers should be used instead of string concatenation.");
            }
        }
    }

    private static boolean isIncorrectConcatenation(ExpressionTree formatStringTree) {
        return formatStringTree.is(new Tree.Kind[]{Tree.Kind.PLUS}) && !formatStringTree.asConstant().isPresent();
    }

    private static boolean isLoggingMethod(MethodInvocationTree mit) {
        String methodName = mit.symbol().name();
        return "log".equals(methodName) || LEVELS.contains(methodName);
    }
}

