/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.Javadoc;
import org.sonar.java.checks.serialization.SerializableContract;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="RedundantThrowsDeclarationCheck", repositoryKey="squid")
@Rule(key="S1130")
public class RedundantThrowsDeclarationCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        ListTree thrownList = ((MethodTree)tree).throwsClauses();
        if (thrownList.isEmpty()) {
            return;
        }
        this.checkMethodThrownList((MethodTree)tree, (ListTree<TypeTree>)thrownList);
    }

    private void checkMethodThrownList(MethodTree methodTree, ListTree<TypeTree> thrownList) {
        Set<Type> thrownExceptions = RedundantThrowsDeclarationCheck.thrownExceptionsFromBody(methodTree);
        boolean isOverridableMethod = JUtils.isOverridable((Symbol.MethodSymbol)methodTree.symbol());
        List<String> undocumentedExceptionNames = new Javadoc((Tree)methodTree).undocumentedThrownExceptions();
        HashSet<String> reported = new HashSet<String>();
        for (TypeTree typeTree : thrownList) {
            String fullyQualifiedName;
            Type exceptionType = typeTree.symbolType();
            if (exceptionType.isUnknown() || reported.contains(fullyQualifiedName = exceptionType.fullyQualifiedName())) continue;
            String superTypeName = RedundantThrowsDeclarationCheck.isSubclassOfAny(exceptionType, thrownList);
            if (superTypeName != null && !exceptionType.isSubtypeOf("java.lang.RuntimeException")) {
                this.reportIssue((Tree)typeTree, String.format("Remove the declaration of thrown exception '%s' which is a subclass of '%s'.", fullyQualifiedName, superTypeName));
            } else if (RedundantThrowsDeclarationCheck.declaredMoreThanOnce(fullyQualifiedName, thrownList)) {
                this.reportIssue((Tree)typeTree, String.format("Remove the redundant '%s' thrown exception declaration(s).", fullyQualifiedName));
            } else if (RedundantThrowsDeclarationCheck.canNotBeThrown(methodTree, exceptionType, thrownExceptions) && (!isOverridableMethod || undocumentedExceptionNames.contains(exceptionType.name()))) {
                this.reportIssue((Tree)typeTree, String.format("Remove the declaration of thrown exception '%s', as it cannot be thrown from %s's body.", fullyQualifiedName, RedundantThrowsDeclarationCheck.methodTreeType(methodTree)));
            }
            reported.add(fullyQualifiedName);
        }
    }

    private static String methodTreeType(MethodTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) ? "constructor" : "method";
    }

    private static boolean canNotBeThrown(MethodTree methodTree, Type exceptionType, @Nullable Set<Type> thrownExceptions) {
        if (RedundantThrowsDeclarationCheck.isOverridingOrDesignedForExtension(methodTree) || !exceptionType.isSubtypeOf("java.lang.Exception") || exceptionType.isSubtypeOf("java.lang.RuntimeException") || thrownExceptions == null || thrownExceptions.stream().anyMatch(JUtils::isTypeVar)) {
            return false;
        }
        return thrownExceptions.stream().noneMatch(t -> t.isSubtypeOf(exceptionType));
    }

    private static boolean isOverridingOrDesignedForExtension(MethodTree methodTree) {
        return !Boolean.FALSE.equals(methodTree.isOverriding()) || SerializableContract.SERIALIZABLE_CONTRACT_METHODS.contains(methodTree.simpleName().name()) || RedundantThrowsDeclarationCheck.isDesignedForExtension(methodTree);
    }

    private static boolean isDesignedForExtension(MethodTree methodTree) {
        ModifiersTree modifiers = methodTree.modifiers();
        if (ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.PRIVATE)) {
            return false;
        }
        return ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.DEFAULT) || RedundantThrowsDeclarationCheck.emptyBody(methodTree) || RedundantThrowsDeclarationCheck.onlyReturnLiteralsOrThrowException(methodTree);
    }

    private static boolean onlyReturnLiteralsOrThrowException(MethodTree methodTree) {
        BlockTree block = methodTree.block();
        if (block == null) {
            return false;
        }
        List body = block.body();
        if (body.size() != 1) {
            return false;
        }
        StatementTree singleStatement = (StatementTree)body.get(0);
        return singleStatement.is(new Tree.Kind[]{Tree.Kind.THROW_STATEMENT}) || RedundantThrowsDeclarationCheck.returnStatementWithLiteral(singleStatement);
    }

    private static boolean returnStatementWithLiteral(StatementTree statement) {
        if (statement.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            ExpressionTree expression = ((ReturnStatementTree)statement).expression();
            return expression == null || ExpressionUtils.skipParentheses((ExpressionTree)expression).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.INT_LITERAL});
        }
        return false;
    }

    private static boolean emptyBody(MethodTree methodTree) {
        BlockTree block = methodTree.block();
        return block != null && block.body().isEmpty();
    }

    @Nullable
    private static Set<Type> thrownExceptionsFromBody(MethodTree methodTree) {
        BlockTree block = methodTree.block();
        if (block != null) {
            ThrownExceptionVisitor visitor = new ThrownExceptionVisitor(methodTree);
            block.accept((TreeVisitor)visitor);
            return visitor.thrownExceptions();
        }
        return null;
    }

    private static boolean declaredMoreThanOnce(String fullyQualifiedName, ListTree<TypeTree> thrown) {
        boolean firstOccurrenceFound = false;
        for (TypeTree typeTree : thrown) {
            if (!typeTree.symbolType().is(fullyQualifiedName)) continue;
            if (firstOccurrenceFound) {
                return true;
            }
            firstOccurrenceFound = true;
        }
        return false;
    }

    private static String isSubclassOfAny(Type type, ListTree<TypeTree> thrownList) {
        for (TypeTree thrown : thrownList) {
            String name = thrown.symbolType().fullyQualifiedName();
            if (type.is(name) || !type.isSubtypeOf(name)) continue;
            return name;
        }
        return null;
    }

    private static class ThrownExceptionVisitor
    extends BaseTreeVisitor {
        private Set<Type> thrownExceptions = new HashSet<Type>();
        private boolean visitedUnknown = false;
        private boolean visitedOtherConstructor = false;
        private final MethodTree methodTree;
        private static final String CONSTRUCTOR_NAME = "<init>";

        ThrownExceptionVisitor(MethodTree methodTree) {
            this.methodTree = methodTree;
        }

        @Nullable
        public Set<Type> thrownExceptions() {
            if (this.visitedUnknown || this.thrownExceptions.stream().anyMatch(Type::isUnknown)) {
                return null;
            }
            if (this.methodTree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) && !this.visitedOtherConstructor) {
                ThrownExceptionVisitor.getImplicitlyCalledConstructor(this.methodTree).map(Symbol.MethodSymbol::thrownTypes).ifPresent(this.thrownExceptions::addAll);
            }
            return this.thrownExceptions;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (CONSTRUCTOR_NAME.equals(tree.symbol().name())) {
                this.visitedOtherConstructor = true;
            }
            this.addThrownTypes(tree.symbol());
            super.visitMethodInvocation(tree);
        }

        public void visitNewClass(NewClassTree tree) {
            this.addThrownTypes(tree.constructorSymbol());
            super.visitNewClass(tree);
        }

        private void addThrownTypes(Symbol methodSymbol) {
            if (!this.visitedUnknown) {
                if (methodSymbol.isUnknown() || !methodSymbol.isMethodSymbol()) {
                    this.visitedUnknown = true;
                } else {
                    this.thrownExceptions.addAll(((Symbol.MethodSymbol)methodSymbol).thrownTypes());
                }
            }
        }

        public void visitThrowStatement(ThrowStatementTree tree) {
            Type exceptionType = tree.expression().symbolType();
            this.thrownExceptions.add(exceptionType);
            super.visitThrowStatement(tree);
        }

        public void visitTryStatement(TryStatementTree tree) {
            for (Tree resource : tree.resourceList()) {
                Type resourceType = ThrownExceptionVisitor.resourceType(resource);
                List<Type> thrownTypes = ThrownExceptionVisitor.closeMethodThrownTypes(resourceType);
                if (thrownTypes == null) {
                    this.visitedUnknown = true;
                    continue;
                }
                this.thrownExceptions.addAll(thrownTypes);
            }
            super.visitTryStatement(tree);
        }

        private static Type resourceType(Tree resource) {
            if (resource.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                return ((VariableTree)resource).type().symbolType();
            }
            return ((TypeTree)resource).symbolType();
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        @CheckForNull
        private static List<Type> closeMethodThrownTypes(Type classType) {
            return classType.symbol().lookupSymbols("close").stream().filter(Symbol::isMethodSymbol).map(Symbol.MethodSymbol.class::cast).filter(method -> method.parameterTypes().isEmpty()).map(Symbol.MethodSymbol::thrownTypes).findFirst().orElseGet(() -> ThrownExceptionVisitor.directSuperTypeStream(classType).map(ThrownExceptionVisitor::closeMethodThrownTypes).filter(Objects::nonNull).findFirst().orElse(null));
        }

        private static Stream<Type> directSuperTypeStream(Type classType) {
            Symbol.TypeSymbol symbol = classType.symbol();
            Stream<Type> interfaceStream = symbol.interfaces().stream();
            Type superClass = symbol.superClass();
            return superClass != null ? Stream.concat(Stream.of(superClass), interfaceStream) : interfaceStream;
        }

        private static Optional<Symbol.MethodSymbol> getImplicitlyCalledConstructor(MethodTree methodTree) {
            Type superType = ((Symbol.TypeSymbol)methodTree.symbol().owner()).superClass();
            if (superType == null) {
                return Optional.empty();
            }
            return Objects.requireNonNull(superType).symbol().memberSymbols().stream().filter(ThrownExceptionVisitor::isDefaultConstructor).map(Symbol.MethodSymbol.class::cast).findFirst();
        }

        private static boolean isDefaultConstructor(Symbol symbol) {
            Symbol.MethodSymbol methodSymbol;
            if (symbol.isMethodSymbol() && CONSTRUCTOR_NAME.equals((methodSymbol = (Symbol.MethodSymbol)symbol).name())) {
                if (methodSymbol.declaration() != null) {
                    return methodSymbol.declaration().parameters().isEmpty();
                }
                return methodSymbol.parameterTypes().isEmpty();
            }
            return false;
        }
    }
}

