/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1942")
public class SimpleClassNameCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Replace this fully qualified name with \"%s\"";
    private static final Predicate<Tree> NOT_EMPTY_STATEMENT = t -> !t.is(new Tree.Kind[]{Tree.Kind.EMPTY_STATEMENT});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.COMPILATION_UNIT);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        CompilationUnitTree cut = (CompilationUnitTree)tree;
        cut.types().stream().filter(NOT_EMPTY_STATEMENT).map(t -> ((ClassTree)t).symbol()).forEach(this::checkSymbol);
        List<ImportTree> imports = cut.imports().stream().filter(NOT_EMPTY_STATEMENT).map(ImportTree.class::cast).collect(Collectors.toList());
        boolean fileContainsStarImport = imports.stream().filter(it -> it.qualifiedIdentifier().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})).map(it -> ((MemberSelectExpressionTree)it.qualifiedIdentifier()).identifier()).anyMatch(i -> "*".equals(i.name()));
        if (!fileContainsStarImport) {
            this.checkImports(imports);
        }
    }

    private void checkImports(List<ImportTree> imports) {
        imports.stream().map(JUtils::importTreeSymbol).filter(Objects::nonNull).forEach(this::checkSymbol);
    }

    private void checkSymbol(Symbol symbol) {
        for (IdentifierTree usageIdentifier : symbol.usages()) {
            Tree parent = usageIdentifier.parent();
            if (!parent.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) || !((MemberSelectExpressionTree)parent).expression().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) continue;
            this.reportIssue(parent, String.format(MESSAGE, symbol.name()));
        }
    }
}

