/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2130")
public class StringToPrimitiveConversionCheck
extends IssuableSubscriptionVisitor {
    private final List<PrimitiveCheck> primitiveChecks = this.buildPrimitiveChecks();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.VARIABLE, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                VariableTree variableTree = (VariableTree)tree;
                Type variableType = variableTree.type().symbolType();
                PrimitiveCheck primitiveCheck = this.getPrimitiveCheck(variableType);
                ExpressionTree initializer = variableTree.initializer();
                if (primitiveCheck != null && initializer != null) {
                    primitiveCheck.checkInstantiation(initializer);
                }
            } else {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                for (PrimitiveCheck primitiveCheck : this.primitiveChecks) {
                    primitiveCheck.checkMethodInvocation(methodInvocationTree);
                }
            }
        }
    }

    private PrimitiveCheck getPrimitiveCheck(Type type) {
        if (!type.isPrimitive()) {
            return null;
        }
        for (PrimitiveCheck primitiveCheck : this.primitiveChecks) {
            if (!type.isPrimitive(primitiveCheck.tag)) continue;
            return primitiveCheck;
        }
        return null;
    }

    private List<PrimitiveCheck> buildPrimitiveChecks() {
        return Arrays.asList(new PrimitiveCheck("int", "Integer", Type.Primitives.INT), new PrimitiveCheck("boolean", "Boolean", Type.Primitives.BOOLEAN), new PrimitiveCheck("byte", "Byte", Type.Primitives.BYTE), new PrimitiveCheck("double", "Double", Type.Primitives.DOUBLE), new PrimitiveCheck("float", "Float", Type.Primitives.FLOAT), new PrimitiveCheck("long", "Long", Type.Primitives.LONG), new PrimitiveCheck("short", "Short", Type.Primitives.SHORT));
    }

    private class PrimitiveCheck {
        private final String primitiveName;
        private final String className;
        private final Type.Primitives tag;
        private final String message;
        private final MethodMatchers unboxingInvocationMatcher;
        private final MethodMatchers valueOfInvocationMatcher;

        private PrimitiveCheck(String primitiveName, String className, Type.Primitives tag) {
            this.primitiveName = primitiveName;
            this.className = className;
            this.tag = tag;
            this.message = "Use \"" + this.parseMethodName() + "\" for this string-to-" + primitiveName + " conversion.";
            this.unboxingInvocationMatcher = MethodMatchers.create().ofTypes(new String[]{"java.lang." + className}).names(new String[]{primitiveName + "Value"}).addWithoutParametersMatcher().build();
            this.valueOfInvocationMatcher = MethodMatchers.create().ofTypes(new String[]{"java.lang." + className}).names(new String[]{"valueOf"}).addParametersMatcher(new String[]{"java.lang.String"}).build();
        }

        private void checkMethodInvocation(MethodInvocationTree methodInvocationTree) {
            if (this.unboxingInvocationMatcher.matches(methodInvocationTree)) {
                MemberSelectExpressionTree methodSelect = (MemberSelectExpressionTree)methodInvocationTree.methodSelect();
                this.checkInstantiation(methodSelect.expression());
            }
        }

        private void checkInstantiation(ExpressionTree expression) {
            if (this.isBadlyInstantiated(expression)) {
                StringToPrimitiveConversionCheck.this.reportIssue((Tree)expression, this.message);
            }
        }

        private boolean isBadlyInstantiated(ExpressionTree expression) {
            IdentifierTree identifier;
            Symbol reference;
            boolean result = false;
            if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
                result = this.isStringBasedConstructor((NewClassTree)expression);
            } else if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                result = this.valueOfInvocationMatcher.matches((MethodInvocationTree)expression);
            } else if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (reference = (identifier = (IdentifierTree)expression).symbol()).isVariableSymbol() && reference.usages().size() == 1) {
                Symbol.VariableSymbol variableSymbol = (Symbol.VariableSymbol)reference;
                result = this.isBadlyInstantiatedVariable(variableSymbol);
            }
            return result;
        }

        private boolean isBadlyInstantiatedVariable(Symbol.VariableSymbol variableSymbol) {
            ExpressionTree initializer;
            VariableTree variableTree = variableSymbol.declaration();
            if (variableTree != null && (initializer = variableTree.initializer()) != null) {
                return this.isBadlyInstantiated(initializer);
            }
            return false;
        }

        private boolean isStringBasedConstructor(NewClassTree newClassTree) {
            Arguments arguments = newClassTree.arguments();
            return ((ExpressionTree)arguments.get(0)).symbolType().is("java.lang.String");
        }

        private String parseMethodName() {
            return this.className + ".parse" + StringUtils.capitalize((String)this.primitiveName);
        }
    }
}

