/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.collections.MapBuilder;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1149")
public class SynchronizedClassUsageCheck
extends IssuableSubscriptionVisitor {
    private static final Map<String, String> REPLACEMENTS = MapBuilder.newMap().put((Object)"java.util.Vector", (Object)"\"ArrayList\" or \"LinkedList\"").put((Object)"java.util.Hashtable", (Object)"\"HashMap\"").put((Object)"java.lang.StringBuffer", (Object)"\"StringBuilder\"").put((Object)"java.util.Stack", (Object)"\"Deque\"").build();
    private final Deque<Set<String>> exclusions = new ArrayDeque<Set<String>>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ExclusionsVisitor exclusionsVisitor = new ExclusionsVisitor();
        tree.accept((TreeVisitor)exclusionsVisitor);
        Set<String> currentClassExclusions = exclusionsVisitor.exclusions;
        if (!this.exclusions.isEmpty()) {
            currentClassExclusions.addAll((Collection<String>)this.exclusions.peek());
        }
        this.exclusions.push(currentClassExclusions);
        tree.accept((TreeVisitor)new DeprecatedTypeVisitor());
    }

    public void leaveNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        this.exclusions.pop();
    }

    private class DeprecatedTypeVisitor
    extends BaseTreeVisitor {
        private DeprecatedTypeVisitor() {
        }

        public void visitClass(ClassTree tree) {
            TypeTree superClass = tree.superClass();
            if (superClass != null) {
                this.reportIssueOnDeprecatedType(ExpressionsHelper.reportOnClassTree(tree), superClass.symbolType());
            }
            this.scan(tree.members());
        }

        public void visitMethod(MethodTree tree) {
            TypeTree returnTypeTree = tree.returnType();
            if (!this.isOverriding(tree) || returnTypeTree == null) {
                if (returnTypeTree != null) {
                    this.reportIssueOnDeprecatedType((Tree)returnTypeTree, returnTypeTree.symbolType());
                }
                this.scan(tree.parameters());
            }
            this.scan((Tree)tree.block());
        }

        private boolean isOverriding(MethodTree tree) {
            return Boolean.TRUE.equals(tree.isOverriding());
        }

        public void visitVariable(VariableTree tree) {
            ExpressionTree initializer = tree.initializer();
            if (!this.reportIssueOnDeprecatedType((Tree)tree.type(), tree.symbol().type()) && initializer != null && !initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                this.reportIssueOnDeprecatedType((Tree)initializer, initializer.symbolType());
            }
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
            this.scan(lambdaExpressionTree.body());
        }

        private boolean reportIssueOnDeprecatedType(Tree tree, Type type) {
            if (this.isDeprecatedType(type)) {
                SynchronizedClassUsageCheck.this.reportIssue(tree, "Replace the synchronized class \"" + type.name() + "\" by an unsynchronized one such as " + (String)REPLACEMENTS.get(type.fullyQualifiedName()) + ".");
                return true;
            }
            return false;
        }

        private boolean isDeprecatedType(Type symbolType) {
            if (symbolType.isClass()) {
                for (String deprecatedType : REPLACEMENTS.keySet()) {
                    if (!symbolType.is(deprecatedType)) continue;
                    return !((Set)SynchronizedClassUsageCheck.this.exclusions.peek()).contains(deprecatedType);
                }
            }
            return false;
        }
    }

    private static class ExclusionsVisitor
    extends BaseTreeVisitor {
        Set<String> exclusions = new HashSet<String>();

        private ExclusionsVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            String fqn;
            if (tree.symbol().isMethodSymbol() && tree.symbol().declaration() == null && ExclusionsVisitor.isMethodFromJavaPackage(fqn = tree.symbol().owner().type().fullyQualifiedName())) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)tree.symbol();
                ArrayList<Type> types = new ArrayList<Type>(methodSymbol.parameterTypes());
                Symbol.TypeSymbol returnType = methodSymbol.returnType();
                if (returnType != null) {
                    types.add(returnType.type());
                }
                types.forEach(t -> this.exclusions.addAll(REPLACEMENTS.keySet().stream().filter(arg_0 -> ((Type)t).isSubtypeOf(arg_0)).collect(Collectors.toSet())));
            }
            super.visitMethodInvocation(tree);
        }

        private static boolean isMethodFromJavaPackage(String fqn) {
            return fqn.startsWith("java") && !REPLACEMENTS.keySet().contains(fqn);
        }
    }
}

