/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.Objects;
import java.util.function.Predicate;
import org.sonar.java.regex.ast.AutomatonState;

public class SubAutomaton {
    public final AutomatonState start;
    public final AutomatonState end;
    public final boolean allowPrefix;

    public SubAutomaton(AutomatonState start, AutomatonState end, boolean allowPrefix) {
        this.start = start;
        this.end = end;
        this.allowPrefix = allowPrefix;
    }

    public AutomatonState.TransitionType incomingTransitionType() {
        return this.start.incomingTransitionType();
    }

    public boolean isAtEnd() {
        return this.start == this.end;
    }

    public boolean anySuccessorMatch(Predicate<SubAutomaton> predicate) {
        for (AutomatonState successor : this.start.successors()) {
            if (!predicate.test(new SubAutomaton(successor, this.end, this.allowPrefix))) continue;
            return true;
        }
        return false;
    }

    public boolean allSuccessorMatch(Predicate<SubAutomaton> predicate) {
        for (AutomatonState successor : this.start.successors()) {
            if (predicate.test(new SubAutomaton(successor, this.end, this.allowPrefix))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubAutomaton automaton = (SubAutomaton)o;
        return this.allowPrefix == automaton.allowPrefix && Objects.equals(this.start, automaton.start) && Objects.equals(this.end, automaton.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.allowPrefix);
    }
}

