/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.RegexTreeHelper;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.regex.RegexCheck;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.ast.CharacterClassTree;
import org.sonar.java.regex.ast.CharacterTree;
import org.sonar.java.regex.ast.RegexBaseVisitor;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.java.regex.ast.SequenceTree;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5854")
public class CanonEqFlagInRegexCheck
extends AbstractRegexCheck {
    protected static final MethodMatchers STRING_MATCHES = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"matches"}).addParametersMatcher(new String[]{"java.lang.String"}).build();
    protected static final MethodMatchers STRING_REPLACE_ALL = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"replaceAll"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.String"}).build();
    protected static final MethodMatchers STRING_REPLACE_FIRST = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"replaceFirst"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.String"}).build();
    protected static final MethodMatchers PATTERN_MATCHES = MethodMatchers.create().ofTypes(new String[]{"java.util.regex.Pattern"}).names(new String[]{"matches"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.CharSequence"}).build();

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        if (regexForLiterals.getInitialFlags().contains(128)) {
            return;
        }
        CharacterVisitor visitor = new CharacterVisitor();
        visitor.visit(regexForLiterals);
        if (!visitor.subjectToNormalization.isEmpty()) {
            String endOfMessage = "this pattern";
            if (methodInvocationOrAnnotation.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                MethodInvocationTree mit = (MethodInvocationTree)methodInvocationOrAnnotation;
                if (STRING_MATCHES.matches(mit) || PATTERN_MATCHES.matches(mit)) {
                    endOfMessage = "\"Pattern.compile(regex, CANON_EQ).matcher(input).matches()\"";
                } else if (STRING_REPLACE_ALL.matches(mit)) {
                    endOfMessage = "\"Pattern.compile(pattern, CANON_EQ).matcher(input).replaceAll(replacement)\"";
                } else if (STRING_REPLACE_FIRST.matches(mit)) {
                    endOfMessage = "\"Pattern.compile(pattern, CANON_EQ).matcher(input).replaceFirst(replacement)\"";
                }
            }
            this.reportIssue((RegexSyntaxElement)regexForLiterals.getResult(), String.format("Use the CANON_EQ flag with %s.", endOfMessage), null, (List<RegexCheck.RegexIssueLocation>)visitor.subjectToNormalization);
        }
    }

    private static class CharacterVisitor
    extends RegexBaseVisitor {
        private final List<RegexCheck.RegexIssueLocation> subjectToNormalization = new ArrayList<RegexCheck.RegexIssueLocation>();

        private CharacterVisitor() {
        }

        public void visitSequence(SequenceTree tree) {
            this.subjectToNormalization.addAll(RegexTreeHelper.getGraphemeInList(tree.getItems()));
            super.visitSequence(tree);
        }

        public void visitCharacterClass(CharacterClassTree tree) {
        }

        public void visitCharacter(CharacterTree tree) {
            String str = tree.characterAsString();
            if (CharacterVisitor.isSubjectToNormalization(str)) {
                this.subjectToNormalization.add(new RegexCheck.RegexIssueLocation((RegexSyntaxElement)tree, ""));
            }
        }

        private static boolean isSubjectToNormalization(String str) {
            return !Normalizer.isNormalized(str, Normalizer.Form.NFD);
        }
    }
}

