/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.SimplifiedRegexCharacterClass;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.regex.RegexCheck;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.ast.CharacterClassElementTree;
import org.sonar.java.regex.ast.CharacterClassUnionTree;
import org.sonar.java.regex.ast.RegexBaseVisitor;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.plugins.java.api.tree.ExpressionTree;

@Rule(key="S5869")
public class DuplicatesInCharacterClassCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Remove duplicates in this character class.";

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        new DuplicateFinder().visit(regexForLiterals);
    }

    private class DuplicateFinder
    extends RegexBaseVisitor {
        private DuplicateFinder() {
        }

        public void visitCharacterClassUnion(CharacterClassUnionTree tree) {
            ArrayList<Object> duplicates = new ArrayList<Object>();
            SimplifiedRegexCharacterClass characterClass = new SimplifiedRegexCharacterClass();
            for (CharacterClassElementTree element : tree.getCharacterClasses()) {
                List<RegexSyntaxElement> intersections = new SimplifiedRegexCharacterClass(element).findIntersections(characterClass);
                if (!intersections.isEmpty()) {
                    for (RegexSyntaxElement intersection : intersections) {
                        if (duplicates.contains(intersection)) continue;
                        duplicates.add(intersection);
                    }
                    duplicates.add(element);
                }
                characterClass.add(element);
            }
            if (!duplicates.isEmpty()) {
                List<RegexCheck.RegexIssueLocation> secondaries = duplicates.stream().skip(1L).map(duplicate -> new RegexCheck.RegexIssueLocation(duplicate, "Additional duplicate")).collect(Collectors.toList());
                DuplicatesInCharacterClassCheck.this.reportIssue((RegexSyntaxElement)duplicates.get(0), DuplicatesInCharacterClassCheck.MESSAGE, null, secondaries);
            }
            super.visitCharacterClassUnion(tree);
        }
    }
}

