/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.Collections;
import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.ast.DisjunctionTree;
import org.sonar.java.regex.ast.GroupTree;
import org.sonar.java.regex.ast.RegexBaseVisitor;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.RepetitionTree;
import org.sonar.java.regex.ast.SequenceTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;

@Rule(key="S5842")
public class EmptyStringRepetitionCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Rework this part of the regex to not match the empty string.";

    @Override
    public void checkRegex(RegexParseResult regex, ExpressionTree methodInvocationOrAnnotation) {
        new Visitor().visit(regex);
    }

    private class Visitor
    extends RegexBaseVisitor {
        private Visitor() {
        }

        public void visitRepetition(RepetitionTree tree) {
            RegexTree element = tree.getElement();
            if (this.matchEmptyString(element)) {
                EmptyStringRepetitionCheck.this.reportIssue((RegexSyntaxElement)element, EmptyStringRepetitionCheck.MESSAGE, null, Collections.emptyList());
            }
        }

        private boolean matchEmptyString(RegexTree element) {
            switch (element.kind()) {
                case SEQUENCE: {
                    return ((SequenceTree)element).getItems().stream().allMatch(this::matchEmptyString);
                }
                case DISJUNCTION: {
                    return ((DisjunctionTree)element).getAlternatives().stream().anyMatch(this::matchEmptyString);
                }
                case REPETITION: {
                    return ((RepetitionTree)element).getQuantifier().getMinimumRepetitions() == 0;
                }
                case LOOK_AROUND: 
                case BOUNDARY: {
                    return true;
                }
            }
            if (element instanceof GroupTree) {
                RegexTree nestedElement = ((GroupTree)element).getElement();
                return nestedElement == null || this.matchEmptyString(nestedElement);
            }
            return false;
        }
    }
}

