/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.regex.RegexCheck;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.ast.BackReferenceTree;
import org.sonar.java.regex.ast.BoundaryTree;
import org.sonar.java.regex.ast.CapturingGroupTree;
import org.sonar.java.regex.ast.DisjunctionTree;
import org.sonar.java.regex.ast.GroupTree;
import org.sonar.java.regex.ast.LookAroundTree;
import org.sonar.java.regex.ast.RegexBaseVisitor;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.SequenceTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;

@Rule(key="S5840")
public class ImpossibleRegexCheck
extends AbstractRegexCheck {
    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        new ImpossiblePatternFinder().visit(regexForLiterals);
    }

    private class ImpossiblePatternFinder
    extends RegexBaseVisitor {
        int groupCount = 0;
        boolean isAtBeginning = true;
        boolean isAtEnd = true;
        List<ImpossibleSubPattern> impossibleSubPatterns = new ArrayList<ImpossibleSubPattern>();

        private ImpossiblePatternFinder() {
        }

        public void visitCapturingGroup(CapturingGroupTree tree) {
            ++this.groupCount;
            super.visitCapturingGroup(tree);
        }

        public void visitBackReference(BackReferenceTree tree) {
            if (tree.isNumerical() && tree.groupNumber() > this.groupCount) {
                this.impossibleSubPatterns.add(new ImpossibleSubPattern((RegexTree)tree, "illegal back reference"));
            }
            super.visitBackReference(tree);
        }

        public void visitSequence(SequenceTree tree) {
            List items = tree.getItems();
            if (items.isEmpty()) {
                return;
            }
            boolean wasAtEnd = this.isAtEnd;
            this.isAtEnd = false;
            int lastConsumingItemIndex = this.findLastConsumingIndex(items);
            for (int i = 0; i < items.size(); ++i) {
                if (i >= lastConsumingItemIndex) {
                    this.isAtEnd = wasAtEnd;
                }
                RegexTree item = (RegexTree)items.get(i);
                this.visit(item);
                if (!this.canConsumeInput(item)) continue;
                this.isAtBeginning = false;
            }
        }

        public void visitDisjunction(DisjunctionTree tree) {
            for (RegexTree alternative : tree.getAlternatives()) {
                this.restoreLocationAfter(() -> this.visit(alternative));
            }
        }

        public void visitLookAround(LookAroundTree tree) {
            this.restoreLocationAfter(() -> super.visitLookAround(tree));
        }

        public void visitBoundary(BoundaryTree tree) {
            switch (tree.type()) {
                case LINE_END: 
                case INPUT_END: 
                case INPUT_END_FINAL_TERMINATOR: {
                    if (this.isAtEnd) break;
                    this.impossibleSubPatterns.add(new ImpossibleSubPattern((RegexTree)tree, "boundary"));
                    break;
                }
                case LINE_START: 
                case INPUT_START: {
                    if (this.isAtBeginning) break;
                    this.impossibleSubPatterns.add(new ImpossibleSubPattern((RegexTree)tree, "boundary"));
                    break;
                }
            }
        }

        public void after(RegexParseResult result) {
            if (this.impossibleSubPatterns.size() == 1) {
                ImpossibleSubPattern pattern2 = this.impossibleSubPatterns.get(0);
                ImpossibleRegexCheck.this.reportIssue((RegexSyntaxElement)pattern2.tree, "Remove this " + pattern2.description + " that can never match or rewrite the regex.", null, Collections.emptyList());
            } else if (this.impossibleSubPatterns.size() > 1) {
                List<RegexCheck.RegexIssueLocation> secondaries = this.impossibleSubPatterns.stream().map(pattern -> new RegexCheck.RegexIssueLocation((RegexSyntaxElement)pattern.tree, pattern.description)).collect(Collectors.toList());
                ImpossibleRegexCheck.this.reportIssue((RegexSyntaxElement)this.impossibleSubPatterns.get((int)0).tree, "Remove these subpatterns that can never match or rewrite the regex.", null, secondaries);
            }
        }

        void restoreLocationAfter(Runnable action) {
            boolean wasAtEnd = this.isAtEnd;
            boolean wasAtBeginning = this.isAtBeginning;
            action.run();
            this.isAtEnd = wasAtEnd;
            this.isAtBeginning = wasAtBeginning;
        }

        int findLastConsumingIndex(List<RegexTree> items) {
            for (int i = items.size() - 1; i >= 0; --i) {
                if (!this.canConsumeInput(items.get(i))) continue;
                return i;
            }
            return -1;
        }

        boolean canConsumeInput(RegexTree tree) {
            if (tree.is(new RegexTree.Kind[]{RegexTree.Kind.SEQUENCE}) && ((SequenceTree)tree).getItems().isEmpty() || tree.is(new RegexTree.Kind[]{RegexTree.Kind.LOOK_AROUND, RegexTree.Kind.BOUNDARY})) {
                return false;
            }
            if (tree instanceof GroupTree) {
                RegexTree element = ((GroupTree)tree).getElement();
                return element != null && this.canConsumeInput(element);
            }
            return true;
        }
    }

    private static class ImpossibleSubPattern {
        RegexTree tree;
        String description;

        public ImpossibleSubPattern(RegexTree tree, String description) {
            this.tree = tree;
            this.description = description;
        }
    }
}

