/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.Collections;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.RegexTreeHelper;
import org.sonar.java.checks.helpers.SubAutomaton;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.regex.RegexCheck;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.ast.AutomatonState;
import org.sonar.java.regex.ast.FinalState;
import org.sonar.java.regex.ast.Quantifier;
import org.sonar.java.regex.ast.RegexBaseVisitor;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.java.regex.ast.RepetitionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;

@Rule(key="S5994")
public class PossessiveQuantifierContinuationCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Change this impossible to match sub-pattern that conflicts with the previous possessive quantifier.";

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        new Visitor(regexForLiterals.getFinalState()).visit(regexForLiterals);
    }

    private class Visitor
    extends RegexBaseVisitor {
        private final FinalState finalState;

        public Visitor(FinalState finalState) {
            this.finalState = finalState;
        }

        public void visitRepetition(RepetitionTree repetitionTree) {
            AutomatonState continuation;
            for (continuation = repetitionTree.continuation(); continuation != null && !(continuation instanceof RegexSyntaxElement); continuation = continuation.continuation()) {
            }
            if (continuation != null && this.doesRepetitionContinuationAlwaysFail(repetitionTree)) {
                PossessiveQuantifierContinuationCheck.this.reportIssue((RegexSyntaxElement)continuation, PossessiveQuantifierContinuationCheck.MESSAGE, null, Collections.singletonList(new RegexCheck.RegexIssueLocation((RegexSyntaxElement)repetitionTree, "Previous possessive repetition")));
            }
            super.visitRepetition(repetitionTree);
        }

        private boolean doesRepetitionContinuationAlwaysFail(RepetitionTree repetitionTree) {
            Quantifier quantifier = repetitionTree.getQuantifier();
            if (!quantifier.isOpenEnded() || quantifier.getModifier() != Quantifier.Modifier.POSSESSIVE) {
                return false;
            }
            SubAutomaton potentialSuperset = new SubAutomaton((AutomatonState)repetitionTree.getElement(), repetitionTree.continuation(), false);
            SubAutomaton potentialSubset = new SubAutomaton(repetitionTree.continuation(), (AutomatonState)this.finalState, true);
            return RegexTreeHelper.supersetOf(potentialSuperset, potentialSubset, false);
        }
    }
}

