/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.Collections;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.RegexTreeHelper;
import org.sonar.java.checks.helpers.SubAutomaton;
import org.sonar.java.checks.regex.AbstractRegexCheckTrackingMatchType;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.ast.AutomatonState;
import org.sonar.java.regex.ast.FinalState;
import org.sonar.java.regex.ast.LookAroundTree;
import org.sonar.java.regex.ast.RegexBaseVisitor;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;

@Rule(key="S6002")
public class RegexLookaheadCheck
extends AbstractRegexCheckTrackingMatchType {
    private static final String MESSAGE = "Remove or fix this lookahead assertion that can never be true.";

    @Override
    protected void checkRegex(RegexParseResult regex, ExpressionTree methodInvocationOrAnnotation, AbstractRegexCheckTrackingMatchType.MatchType matchType) {
        new LookaheadFinder(matchType, regex.getFinalState()).visit(regex);
    }

    private class LookaheadFinder
    extends RegexBaseVisitor {
        private final AbstractRegexCheckTrackingMatchType.MatchType matchType;
        private final FinalState finalState;

        public LookaheadFinder(AbstractRegexCheckTrackingMatchType.MatchType matchType, FinalState finalState) {
            this.matchType = matchType;
            this.finalState = finalState;
        }

        public void visitLookAround(LookAroundTree tree) {
            if (tree.getDirection() == LookAroundTree.Direction.AHEAD && this.doesLookaheadContinuationAlwaysFail(tree)) {
                RegexLookaheadCheck.this.reportIssue((RegexSyntaxElement)tree, RegexLookaheadCheck.MESSAGE, null, Collections.emptyList());
            }
            super.visitLookAround(tree);
        }

        private boolean doesLookaheadContinuationAlwaysFail(LookAroundTree lookAround) {
            RegexTree lookAroundElement = lookAround.getElement();
            boolean canLookAroundBeAPrefix = this.matchType != AbstractRegexCheckTrackingMatchType.MatchType.FULL;
            SubAutomaton lookAroundSubAutomaton = new SubAutomaton((AutomatonState)lookAroundElement, lookAroundElement.continuation(), canLookAroundBeAPrefix);
            SubAutomaton continuationSubAutomaton = new SubAutomaton(lookAround.continuation(), (AutomatonState)this.finalState, true);
            if (lookAround.getPolarity() == LookAroundTree.Polarity.NEGATIVE) {
                return RegexTreeHelper.supersetOf(lookAroundSubAutomaton, continuationSubAutomaton, false);
            }
            return !RegexTreeHelper.intersects(lookAroundSubAutomaton, continuationSubAutomaton, true);
        }
    }
}

