/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.Collections;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.RegexTreeHelper;
import org.sonar.java.checks.regex.AbstractRegexCheckTrackingMatchType;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.ast.AutomatonState;
import org.sonar.java.regex.ast.Quantifier;
import org.sonar.java.regex.ast.RegexBaseVisitor;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.java.regex.ast.RepetitionTree;
import org.sonar.java.regex.ast.StartState;
import org.sonar.plugins.java.api.tree.ExpressionTree;

@Rule(key="S6019")
public class ReluctantQuantifierWithEmptyContinuationCheck
extends AbstractRegexCheckTrackingMatchType {
    private static final String PARTIAL_MATCH_MESSAGE = "Fix this reluctant quantifier that will only ever match the empty string.";
    private static final String FULL_MATCH_MESSAGE = "Remove the '?' from this unnecessarily reluctant quantifier.";

    @Override
    protected void checkRegex(RegexParseResult regex, ExpressionTree methodInvocationOrAnnotation, AbstractRegexCheckTrackingMatchType.MatchType matchType) {
        if (matchType == AbstractRegexCheckTrackingMatchType.MatchType.PARTIAL || matchType == AbstractRegexCheckTrackingMatchType.MatchType.FULL) {
            new ReluctantQuantifierWithEmptyContinuationFinder(matchType).visit(regex);
        }
    }

    private class ReluctantQuantifierWithEmptyContinuationFinder
    extends RegexBaseVisitor {
        private AutomatonState endState;
        private final AbstractRegexCheckTrackingMatchType.MatchType matchType;

        public ReluctantQuantifierWithEmptyContinuationFinder(AbstractRegexCheckTrackingMatchType.MatchType matchType) {
            this.matchType = matchType;
        }

        protected void before(RegexParseResult regexParseResult) {
            this.endState = regexParseResult.getFinalState();
        }

        private boolean isAnchoredAtEnd(AutomatonState state) {
            return this.matchType == AbstractRegexCheckTrackingMatchType.MatchType.FULL || RegexTreeHelper.isAnchoredAtEnd(state);
        }

        public void visitRepetition(RepetitionTree tree) {
            super.visitRepetition(tree);
            if (tree.getQuantifier().getModifier() == Quantifier.Modifier.RELUCTANT) {
                if (this.isAnchoredAtEnd(tree.continuation())) {
                    if (RegexTreeHelper.onlyMatchesEmptySuffix(tree.continuation())) {
                        ReluctantQuantifierWithEmptyContinuationCheck.this.reportIssue((RegexSyntaxElement)tree, ReluctantQuantifierWithEmptyContinuationCheck.FULL_MATCH_MESSAGE, null, Collections.emptyList());
                    }
                } else if (RegexTreeHelper.canReachWithoutConsumingInput((AutomatonState)new StartState(tree.continuation(), tree.activeFlags()), this.endState)) {
                    ReluctantQuantifierWithEmptyContinuationCheck.this.reportIssue((RegexSyntaxElement)tree, ReluctantQuantifierWithEmptyContinuationCheck.PARTIAL_MATCH_MESSAGE, null, Collections.emptyList());
                }
            }
        }
    }
}

