/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.Collections;
import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.ast.CharacterClassElementTree;
import org.sonar.java.regex.ast.DisjunctionTree;
import org.sonar.java.regex.ast.RegexBaseVisitor;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.plugins.java.api.tree.ExpressionTree;

@Rule(key="S6035")
public class SingleCharacterAlternationCheck
extends AbstractRegexCheck {
    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        new SingleCharacterAlternationFinder().visit(regexForLiterals);
    }

    class SingleCharacterAlternationFinder
    extends RegexBaseVisitor {
        SingleCharacterAlternationFinder() {
        }

        public void visitDisjunction(DisjunctionTree tree) {
            if (tree.getAlternatives().stream().allMatch(CharacterClassElementTree.class::isInstance)) {
                SingleCharacterAlternationCheck.this.reportIssue((RegexSyntaxElement)tree, "Replace this alternation with a character class.", null, Collections.emptyList());
            }
            super.visitDisjunction(tree);
        }
    }
}

