/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.ast.CharacterTree;
import org.sonar.java.regex.ast.FlagSet;
import org.sonar.java.regex.ast.RegexBaseVisitor;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.java.regex.ast.SourceCharacter;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5866")
public class UnicodeCaseCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Also use %s to correctly handle non-ASCII letters.";

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        new Visitor(methodInvocationOrAnnotation).visit(regexForLiterals);
    }

    private class Visitor
    extends RegexBaseVisitor {
        final Set<SourceCharacter> problematicFlags = new HashSet<SourceCharacter>();
        boolean problematicFlagSetOutsideOfRegex = false;
        final ExpressionTree methodInvocationOrAnnotation;

        Visitor(ExpressionTree methodInvocationOrAnnotation) {
            this.methodInvocationOrAnnotation = methodInvocationOrAnnotation;
        }

        public void visitCharacter(CharacterTree tree) {
            if (this.isProblematic(tree.activeFlags(), tree.codePointOrUnit())) {
                SourceCharacter character = tree.activeFlags().getJavaCharacterForFlag(2);
                if (character == null) {
                    this.problematicFlagSetOutsideOfRegex = true;
                } else {
                    this.problematicFlags.add(character);
                }
            }
        }

        protected void after(RegexParseResult regexParseResult) {
            if (this.problematicFlagSetOutsideOfRegex) {
                boolean isAnnotation = this.methodInvocationOrAnnotation.is(new Tree.Kind[]{Tree.Kind.ANNOTATION});
                String flagName = isAnnotation ? "\"Flag.UNICODE_CASE\"" : "\"Pattern.UNICODE_CASE\"";
                AbstractRegexCheck.getFlagsTree(this.methodInvocationOrAnnotation).ifPresent(flagsTree -> UnicodeCaseCheck.this.reportIssue((Tree)flagsTree, String.format(UnicodeCaseCheck.MESSAGE, flagName)));
            }
            for (SourceCharacter flag : this.problematicFlags) {
                UnicodeCaseCheck.this.reportIssue((RegexSyntaxElement)flag, String.format(UnicodeCaseCheck.MESSAGE, "the \"u\" flag"), null, Collections.emptyList());
            }
        }

        boolean isNonAsciiLetter(int codePointOrUnit) {
            return codePointOrUnit > 127 && Character.isLetter(codePointOrUnit);
        }

        boolean isProblematic(FlagSet activeFlags, int codePointOrUnit) {
            return activeFlags.contains(2) && !activeFlags.contains(64) && this.isNonAsciiLetter(codePointOrUnit);
        }
    }
}

