/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.HashMap;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5332")
public class ClearTextProtocolCheck
extends AbstractMethodDetection {
    private static final Map<String, Protocol> PROTOCOLS = new HashMap<String, Protocol>();
    private static final String MESSAGE = "Using %s protocol is insecure. Use %s instead.";

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(PROTOCOLS.keySet().toArray(new String[0])).constructor().withAnyParameters().build();
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        Protocol protocol = PROTOCOLS.get(newClassTree.symbolType().fullyQualifiedName());
        String message = String.format(MESSAGE, protocol.protocolName, protocol.alternatives);
        this.reportIssue((Tree)newClassTree.identifier(), message);
    }

    static {
        PROTOCOLS.put("org.apache.commons.net.ftp.FTPClient", new Protocol("FTP", "SFTP, SCP or FTPS"));
        PROTOCOLS.put("org.apache.commons.net.smtp.SMTPClient", new Protocol("clear-text SMTP", "SMTP over SSL/TLS or SMTP with STARTTLS"));
        PROTOCOLS.put("org.apache.commons.net.telnet.TelnetClient", new Protocol("Telnet", "SSH"));
    }

    private static class Protocol {
        String protocolName;
        String alternatives;

        Protocol(String protocolName, String alternatives) {
            this.protocolName = protocolName;
            this.alternatives = alternatives;
        }
    }
}

