/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.AbstractAssertionVisitor;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6103")
public class AssertJAssertionsInConsumerCheck
extends IssuableSubscriptionVisitor {
    private static final String ORG_ASSERTJ_CORE_API_ABSTRACT_ASSERT = "org.assertj.core.api.AbstractAssert";
    public static final String JAVA_UTIL_FUNCTION_CONSUMER = "java.util.function.Consumer";
    private static final MethodMatchers METHODS_WITH_CONSUMER_AT_INDEX_0_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"org.assertj.core.api.AbstractAssert"}).names(new String[]{"allSatisfy", "anySatisfy", "hasOnlyOneElementSatisfying", "noneSatisfy", "satisfies"}).addParametersMatcher(new String[]{"java.util.function.Consumer"}).addParametersMatcher(new String[]{"java.util.function.Consumer", "org.assertj.core.data.Index"}).build();
    private static final MethodMatchers METHODS_WITH_CONSUMER_AT_INDEX_1_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"org.assertj.core.api.AbstractAssert"}).names(new String[]{"isInstanceOfSatisfying", "zipSatisfy"}).addParametersMatcher(arguments -> arguments.size() > 1 && (((Type)arguments.get(1)).is(JAVA_UTIL_FUNCTION_CONSUMER) || ((Type)arguments.get(1)).is("java.util.function.BiConsumer"))).build();
    private static final MethodMatchers SATISFIES_ANY_OF_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"org.assertj.core.api.AbstractAssert"}).names(new String[]{"satisfiesAnyOf"}).withAnyParameters().build();
    private final Map<Symbol, Boolean> assertionInLocalMethod = new HashMap<Symbol, Boolean>();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree invocation = (MethodInvocationTree)tree;
        if (METHODS_WITH_CONSUMER_AT_INDEX_0_MATCHER.matches(invocation)) {
            this.checkAssertions(invocation, Collections.singletonList((ExpressionTree)invocation.arguments().get(0)));
        } else if (METHODS_WITH_CONSUMER_AT_INDEX_1_MATCHER.matches(invocation)) {
            this.checkAssertions(invocation, Collections.singletonList((ExpressionTree)invocation.arguments().get(1)));
        } else if (SATISFIES_ANY_OF_MATCHER.matches(invocation)) {
            this.checkAssertions(invocation, (List<ExpressionTree>)invocation.arguments());
        }
    }

    public void leaveFile(JavaFileScannerContext context) {
        this.assertionInLocalMethod.clear();
        super.leaveFile(context);
    }

    private void checkAssertions(MethodInvocationTree invocation, List<ExpressionTree> argumentsToCheck) {
        List argumentsMissingAssertion = argumentsToCheck.stream().filter(argument -> !this.hasAssertion((ExpressionTree)argument)).map(argument -> new JavaFileScannerContext.Location("Argument missing assertion", (Tree)argument)).collect(Collectors.toList());
        if (!argumentsMissingAssertion.isEmpty()) {
            IdentifierTree methodName = ExpressionUtils.methodName((MethodInvocationTree)invocation);
            this.reportIssue((Tree)methodName, "Rework this assertion to assert something inside the Consumer argument.", argumentsMissingAssertion, null);
        }
    }

    private boolean hasAssertion(@Nullable ExpressionTree expressionTree) {
        if (expressionTree == null) {
            return true;
        }
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Tree argumentDeclaration = ((IdentifierTree)expressionTree).symbol().declaration();
            return argumentDeclaration instanceof VariableTree && this.hasAssertion(((VariableTree)argumentDeclaration).initializer());
        }
        AssertionVisitor assertionVisitor = new AssertionVisitor();
        expressionTree.accept((TreeVisitor)assertionVisitor);
        return assertionVisitor.hasAssertion();
    }

    private class AssertionVisitor
    extends AbstractAssertionVisitor {
        private AssertionVisitor() {
        }

        @Override
        protected boolean isAssertion(Symbol methodSymbol) {
            if (!AssertJAssertionsInConsumerCheck.this.assertionInLocalMethod.containsKey(methodSymbol)) {
                AssertJAssertionsInConsumerCheck.this.assertionInLocalMethod.put(methodSymbol, false);
                Tree declaration = methodSymbol.declaration();
                if (declaration != null) {
                    AssertionVisitor assertionVisitor = new AssertionVisitor();
                    declaration.accept((TreeVisitor)assertionVisitor);
                    AssertJAssertionsInConsumerCheck.this.assertionInLocalMethod.put(methodSymbol, assertionVisitor.hasAssertion());
                }
            }
            return (Boolean)AssertJAssertionsInConsumerCheck.this.assertionInLocalMethod.get(methodSymbol);
        }
    }
}

