/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.collections.MapBuilder;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5793")
public class JUnit4AnnotationsCheck
extends IssuableSubscriptionVisitor {
    private static final Map<String, String> OLD_NEW_ANNOTATIONS_MAP = MapBuilder.newMap().put((Object)"org.junit.Test", (Object)"org.junit.jupiter.api.Test").put((Object)"org.junit.Before", (Object)"org.junit.jupiter.api.BeforeEach").put((Object)"org.junit.After", (Object)"org.junit.jupiter.api.AfterEach").put((Object)"org.junit.BeforeClass", (Object)"org.junit.jupiter.api.BeforeAll").put((Object)"org.junit.AfterClass", (Object)"org.junit.jupiter.api.AfterAll").put((Object)"org.junit.Ignore", (Object)"org.junit.jupiter.api.Disabled").put((Object)"org.junit.experimental.categories.Category", (Object)"org.junit.jupiter.api.Tag").put((Object)"org.junit.Rule", (Object)"org.junit.jupiter.api.extension.ExtendWith").put((Object)"org.junit.ClassRule", (Object)"org.junit.jupiter.api.extension.RegisterExtension").put((Object)"org.junit.runner.RunWith", (Object)"org.junit.jupiter.api.extension.ExtendWith").build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.ANNOTATION);
    }

    public void visitNode(Tree tree) {
        String qualifiedName = ((AnnotationTree)tree).annotationType().symbolType().fullyQualifiedName();
        if (OLD_NEW_ANNOTATIONS_MAP.containsKey(qualifiedName)) {
            this.reportIssue(tree, String.format("Change this JUnit4 %s to the equivalent JUnit5 %s annotation.", qualifiedName, OLD_NEW_ANNOTATIONS_MAP.get(qualifiedName)));
        }
    }
}

