/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1610")
public class AbstractClassNoFieldShouldBeInterfaceCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    private static final List<String> CLASS_ANNOTATIONS = Arrays.asList("com.google.auto.value.AutoValue", "com.google.auto.value.AutoValue$Builder", "com.google.auto.value.AutoOneOf", "org.immutables.value.Value$Immutable");
    private int javaVersionAsInt;

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    public void setContext(JavaFileScannerContext context) {
        this.javaVersionAsInt = context.getJavaVersion().asInt();
        super.setContext(context);
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.superClass() == null && AbstractClassNoFieldShouldBeInterfaceCheck.classIsAbstract(classTree) && AbstractClassNoFieldShouldBeInterfaceCheck.classHasNoFieldAndProtectedMethod(classTree) && AbstractClassNoFieldShouldBeInterfaceCheck.classHasNoAutoValueOrImmutableAnnotation(classTree) && this.supportPrivateMethod(classTree)) {
            IdentifierTree simpleName = classTree.simpleName();
            this.reportIssue((Tree)simpleName, "Convert the abstract class \"" + simpleName.name() + "\" into an interface." + this.context.getJavaVersion().java8CompatibilityMessage());
        }
    }

    private static boolean classIsAbstract(ClassTree tree) {
        return ModifiersUtils.hasModifier((ModifiersTree)tree.modifiers(), (Modifier)Modifier.ABSTRACT);
    }

    private boolean supportPrivateMethod(ClassTree tree) {
        return !AbstractClassNoFieldShouldBeInterfaceCheck.hasPrivateMethod(tree) || this.javaVersionAsInt >= 9;
    }

    private static boolean hasPrivateMethod(ClassTree tree) {
        return tree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).anyMatch(member -> ModifiersUtils.hasModifier((ModifiersTree)((MethodTree)member).modifiers(), (Modifier)Modifier.PRIVATE));
    }

    private static boolean classHasNoFieldAndProtectedMethod(ClassTree tree) {
        return tree.members().stream().noneMatch(member -> member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || member.is(new Tree.Kind[]{Tree.Kind.METHOD}) && AbstractClassNoFieldShouldBeInterfaceCheck.isProtectedOrOverriding((MethodTree)member));
    }

    private static boolean isProtectedOrOverriding(MethodTree member) {
        return ModifiersUtils.hasModifier((ModifiersTree)member.modifiers(), (Modifier)Modifier.PROTECTED) || !Boolean.FALSE.equals(member.isOverriding());
    }

    private static boolean classHasNoAutoValueOrImmutableAnnotation(ClassTree tree) {
        SymbolMetadata classMetadata = tree.symbol().metadata();
        return CLASS_ANNOTATIONS.stream().noneMatch(arg_0 -> ((SymbolMetadata)classMetadata).isAnnotatedWith(arg_0));
    }
}

