/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3011")
public class AccessibilityChangeCheck
extends AbstractMethodDetection {
    private static final String JAVA_LANG_REFLECT_FIELD = "java.lang.reflect.Field";
    private static final MethodMatchers METHOD_MATCHERS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"java.lang.reflect.AccessibleObject"}).names(new String[]{"setAccessible"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.reflect.Field"}).names(new String[]{"set"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.reflect.Field"}).names(new String[]{"setBoolean"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.reflect.Field"}).names(new String[]{"setByte"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.reflect.Field"}).names(new String[]{"setChar"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.reflect.Field"}).names(new String[]{"setDouble"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.reflect.Field"}).names(new String[]{"setFloat"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.reflect.Field"}).names(new String[]{"setInt"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.reflect.Field"}).names(new String[]{"setLong"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.reflect.Field"}).names(new String[]{"setShort"}).withAnyParameters().build()});

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return METHOD_MATCHERS;
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (mit.symbol().name().equals("setAccessible")) {
            this.checkAccessibilityUpdate(mit);
        } else {
            this.reportIssue((Tree)mit, "Make sure that this accessibility bypass is safe here.");
        }
    }

    private void checkAccessibilityUpdate(MethodInvocationTree mit) {
        Arguments arguments = mit.arguments();
        ExpressionTree arg = (ExpressionTree)arguments.get(0);
        if (arguments.size() > 1) {
            arg = (ExpressionTree)arguments.get(1);
        }
        if (Boolean.TRUE.equals(ExpressionsHelper.getConstantValueAsBoolean(arg).value())) {
            this.reportIssue((Tree)mit, "Make sure that this accessibility update is safe here.");
        }
    }
}

