/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3658")
public class AssertionFailInCatchBlockCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"org.junit.Assert"}).names(new String[]{"fail"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.junit.jupiter.api.Assertions"}).names(new String[]{"fail"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"junit.framework.Assert"}).name(name -> name.startsWith("fail")).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.fest.assertions.Fail"}).names(new String[]{"fail"}).withAnyParameters().build()});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (AssertionFailInCatchBlockCheck.isInCatch((Tree)mit)) {
            this.reportIssue((Tree)mit, "Remove this failure assertion and simply add the exception type to the method signature.");
        }
    }

    private static boolean isInCatch(Tree tree) {
        Tree parent = tree.parent();
        return parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.METHOD}) && (parent.is(new Tree.Kind[]{Tree.Kind.CATCH}) || AssertionFailInCatchBlockCheck.isInCatch(parent));
    }
}

