/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2699")
public class AssertionsInTestsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Logger LOG = Loggers.get(AssertionsInTestsCheck.class);
    private static final Pattern ASSERTION_METHODS_PATTERN = Pattern.compile("(assert|verify|fail|should|check|expect|validate).*");
    private static final Pattern TEST_METHODS_PATTERN = Pattern.compile("test.*|.*Test");
    private static final MethodMatchers ASSERTION_INVOCATION_MATCHERS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"org.fest.assertions.GenericAssert", "org.fest.assertions.api.AbstractAssert"}).anyName().withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"io.restassured.response.ValidatableResponseOptions"}).name(name -> name.equals("body") || name.equals("time") || name.startsWith("time") || name.startsWith("content") || name.startsWith("status") || name.startsWith("header") || name.startsWith("cookie") || name.startsWith("spec")).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"org.assertj.core.api.AbstractAssert"}).anyName().withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.springframework.test.web.servlet.ResultActions"}).names(new String[]{"andExpect"}).addParametersMatcher(t -> true).build(), MethodMatchers.create().ofTypes(new String[]{"mockit.Verifications"}).constructor().withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"io.vertx.ext.unit.TestContext"}).name(name -> name.startsWith("asyncAssert")).addWithoutParametersMatcher().build()});
    private static final MethodMatchers REACTIVE_X_TEST_METHODS = MethodMatchers.create().ofSubTypes(new String[]{"rx.Observable", "io.reactivex.Observable"}).names(new String[]{"test"}).withAnyParameters().build();
    @RuleProperty(key="customAssertionMethods", description="Comma-separated list of fully qualified method symbols that should be considered as assertion methods. The wildcard character can be used at the end of the method name.", defaultValue="")
    public String customAssertionMethods = "";
    private MethodMatchers customAssertionMethodsMatcher = null;
    private final Map<Symbol, Boolean> assertionInMethod = new HashMap<Symbol, Boolean>();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (context.getSemanticModel() == null) {
            return;
        }
        this.context = context;
        this.assertionInMethod.clear();
        this.scan((Tree)context.getTree());
        this.assertionInMethod.clear();
    }

    public void visitMethod(MethodTree methodTree) {
        if (ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.ABSTRACT)) {
            return;
        }
        if (AssertionsInTestsCheck.isUnitTest(methodTree) && !AssertionsInTestsCheck.expectAssertion(methodTree) && !this.isLocalMethodWithAssertion((Symbol)methodTree.symbol())) {
            this.context.reportIssue((JavaCheck)this, (Tree)methodTree.simpleName(), "Add at least one assertion to this test case.");
        }
    }

    private boolean isLocalMethodWithAssertion(Symbol symbol) {
        if (!this.assertionInMethod.containsKey(symbol)) {
            this.assertionInMethod.put(symbol, false);
            Tree declaration = symbol.declaration();
            if (declaration != null) {
                AssertionVisitor assertionVisitor = new AssertionVisitor(this.getCustomAssertionMethodsMatcher());
                declaration.accept((TreeVisitor)assertionVisitor);
                this.assertionInMethod.put(symbol, assertionVisitor.hasAssertion);
            }
        }
        return this.assertionInMethod.get(symbol);
    }

    private MethodMatchers getCustomAssertionMethodsMatcher() {
        if (this.customAssertionMethodsMatcher == null) {
            String[] fullyQualifiedMethodSymbols = this.customAssertionMethods.isEmpty() ? new String[]{} : this.customAssertionMethods.split(",");
            ArrayList<MethodMatchers> customMethodMatchers = new ArrayList<MethodMatchers>(fullyQualifiedMethodSymbols.length);
            for (String fullyQualifiedMethodSymbol : fullyQualifiedMethodSymbols) {
                String[] methodMatcherParts = fullyQualifiedMethodSymbol.split("#");
                if (methodMatcherParts.length == 2 && !StringUtils.isEmpty((String)methodMatcherParts[0].trim()) && !StringUtils.isEmpty((String)methodMatcherParts[1].trim())) {
                    String methodName = methodMatcherParts[1].trim();
                    Predicate<String> namePredicate = methodName.endsWith("*") ? name -> name.startsWith(methodName.substring(0, methodName.length() - 1)) : name -> name.equals(methodName);
                    customMethodMatchers.add(MethodMatchers.create().ofSubTypes(new String[]{methodMatcherParts[0].trim()}).name(namePredicate).withAnyParameters().build());
                    continue;
                }
                LOG.warn("Unable to create a corresponding matcher for custom assertion method, please check the format of the following symbol: '{}'", (Object)fullyQualifiedMethodSymbol);
            }
            this.customAssertionMethodsMatcher = MethodMatchers.or(customMethodMatchers);
        }
        return this.customAssertionMethodsMatcher;
    }

    private static boolean expectAssertion(MethodTree methodTree) {
        List annotationValues = methodTree.symbol().metadata().valuesForAnnotation("org.junit.Test");
        if (annotationValues != null) {
            for (SymbolMetadata.AnnotationValue annotationValue : annotationValues) {
                if (!"expected".equals(annotationValue.name())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isUnitTest(MethodTree methodTree) {
        for (Symbol.MethodSymbol symbol = methodTree.symbol(); symbol != null; symbol = symbol.overriddenSymbol()) {
            if (!symbol.metadata().isAnnotatedWith("org.junit.Test")) continue;
            return true;
        }
        if (UnitTestUtils.hasJUnit5TestAnnotation(methodTree)) {
            return true;
        }
        Symbol.TypeSymbol enclosingClass = methodTree.symbol().enclosingClass();
        return enclosingClass != null && enclosingClass.type().isSubtypeOf("junit.framework.TestCase") && methodTree.simpleName().name().startsWith("test");
    }

    private class AssertionVisitor
    extends BaseTreeVisitor {
        boolean hasAssertion = false;
        private MethodMatchers customMethodsMatcher;

        private AssertionVisitor(MethodMatchers customMethodsMatcher) {
            this.customMethodsMatcher = customMethodsMatcher;
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            super.visitMethodInvocation(mit);
            if (!this.hasAssertion && this.isAssertion(ExpressionUtils.methodName((MethodInvocationTree)mit), mit.symbol())) {
                this.hasAssertion = true;
            }
        }

        public void visitMethodReference(MethodReferenceTree methodReferenceTree) {
            super.visitMethodReference(methodReferenceTree);
            if (!this.hasAssertion && this.isAssertion(methodReferenceTree.method(), methodReferenceTree.method().symbol())) {
                this.hasAssertion = true;
            }
        }

        public void visitNewClass(NewClassTree tree) {
            super.visitNewClass(tree);
            if (!this.hasAssertion && this.isAssertion(null, tree.constructorSymbol())) {
                this.hasAssertion = true;
            }
        }

        private boolean isAssertion(@Nullable IdentifierTree method, Symbol methodSymbol) {
            return this.matchesMethodPattern(method, methodSymbol) || ASSERTION_INVOCATION_MATCHERS.matches(methodSymbol) || this.customMethodsMatcher.matches(methodSymbol) || AssertionsInTestsCheck.this.isLocalMethodWithAssertion(methodSymbol);
        }

        private boolean matchesMethodPattern(@Nullable IdentifierTree method, Symbol methodSymbol) {
            if (method == null) {
                return false;
            }
            String methodName = method.name();
            if (TEST_METHODS_PATTERN.matcher(methodName).matches()) {
                return !REACTIVE_X_TEST_METHODS.matches(methodSymbol);
            }
            return ASSERTION_METHODS_PATTERN.matcher(methodName).matches();
        }
    }
}

