/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2698")
public class AssertionsWithoutMessageCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Add a message to this assertion.";
    private static final String ASSERT = "assert";
    private static final String GENERIC_ASSERT = "org.fest.assertions.GenericAssert";
    private static final MethodMatchers FEST_AS_METHOD = MethodMatchers.create().ofSubTypes(new String[]{"org.fest.assertions.GenericAssert"}).names(new String[]{"as"}).addParametersMatcher(new String[]{"java.lang.String"}).build();
    private static final Set<String> ASSERT_METHODS_WITH_ONE_PARAM = ImmutableSet.of((Object)"assertNull", (Object)"assertNotNull");
    private static final Set<String> ASSERT_METHODS_WITH_TWO_PARAMS = ImmutableSet.of((Object)"assertEquals", (Object)"assertSame", (Object)"assertNotSame", (Object)"assertThat");
    private static final Set<String> JUNIT5_ASSERT_METHODS_IGNORED = ImmutableSet.of((Object)"assertAll", (Object)"assertLinesMatch");
    private static final Set<String> JUNIT5_ASSERT_METHODS_WITH_ONE_PARAM = ImmutableSet.of((Object)"assertTrue", (Object)"assertFalse", (Object)"assertNull", (Object)"assertNotNull", (Object)"assertDoesNotThrow");
    private static final Set<String> JUNIT5_ASSERT_METHODS_WITH_DELTA = ImmutableSet.of((Object)"assertArrayEquals", (Object)"assertEquals");

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"org.junit.jupiter.api.Assertions"}).name(name -> name.startsWith(ASSERT)).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.junit.Assert"}).name(name -> name.startsWith(ASSERT) || name.equals("fail")).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"junit.framework.Assert"}).name(name -> name.startsWith(ASSERT) || name.startsWith("fail")).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.fest.assertions.Fail"}).name(name -> name.startsWith("fail")).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{GENERIC_ASSERT}).anyName().withAnyParameters().build()});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Symbol symbol = mit.symbol();
        if (symbol.owner().type().isSubtypeOf(GENERIC_ASSERT) && !FEST_AS_METHOD.matches(mit)) {
            if (AssertionsWithoutMessageCheck.isConstructor(symbol)) {
                return;
            }
            FestVisitor visitor = new FestVisitor();
            mit.methodSelect().accept((TreeVisitor)visitor);
            if (!visitor.useDescription) {
                this.reportIssue((Tree)mit, MESSAGE);
            }
        } else if (symbol.owner().type().is("org.junit.jupiter.api.Assertions")) {
            this.checkJUnit5(mit);
        } else if (mit.arguments().isEmpty() || !AssertionsWithoutMessageCheck.isString((ExpressionTree)mit.arguments().get(0)) || AssertionsWithoutMessageCheck.isAssertingOnStringWithNoMessage(mit)) {
            this.reportIssue((Tree)mit, MESSAGE);
        }
    }

    private void checkJUnit5(MethodInvocationTree mit) {
        Type thirdArgumentType;
        String methodName = mit.symbol().name();
        if (JUNIT5_ASSERT_METHODS_IGNORED.contains(methodName)) {
            return;
        }
        if (JUNIT5_ASSERT_METHODS_WITH_ONE_PARAM.contains(methodName)) {
            if (mit.arguments().size() == 1) {
                this.reportIssue((Tree)mit, MESSAGE);
            }
        } else if (mit.arguments().size() == 2) {
            this.reportIssue((Tree)mit, MESSAGE);
        } else if (JUNIT5_ASSERT_METHODS_WITH_DELTA.contains(methodName) && mit.arguments().size() == 3 && ((thirdArgumentType = ((ExpressionTree)mit.arguments().get(2)).symbolType()).isPrimitive(Type.Primitives.DOUBLE) || thirdArgumentType.isPrimitive(Type.Primitives.FLOAT))) {
            this.reportIssue((Tree)mit, MESSAGE);
        }
    }

    private static boolean isConstructor(Symbol symbol) {
        return "<init>".equals(symbol.name());
    }

    private static boolean isAssertingOnStringWithNoMessage(MethodInvocationTree mit) {
        return AssertionsWithoutMessageCheck.isAssertWithTwoParams(mit) || AssertionsWithoutMessageCheck.isAssertWithOneParam(mit);
    }

    private static boolean isAssertWithOneParam(MethodInvocationTree mit) {
        return ASSERT_METHODS_WITH_ONE_PARAM.contains(mit.symbol().name()) && mit.arguments().size() == 1;
    }

    private static boolean isAssertWithTwoParams(MethodInvocationTree mit) {
        return ASSERT_METHODS_WITH_TWO_PARAMS.contains(mit.symbol().name()) && mit.arguments().size() == 2;
    }

    private static boolean isString(ExpressionTree expressionTree) {
        return expressionTree.symbolType().is("java.lang.String");
    }

    private static class FestVisitor
    extends BaseTreeVisitor {
        boolean useDescription = false;

        private FestVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            this.useDescription |= FEST_AS_METHOD.matches(tree);
            super.visitMethodInvocation(tree);
        }
    }
}

