/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2701")
public class BooleanLiteralInAssertionsCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"org.junit.Assert", "org.junit.jupiter.api.Assertions", "junit.framework.Assert", "junit.framework.TestCase"}).name(name -> name.startsWith("assert")).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.fest.assertions.Assertions"}).names(new String[]{"assertThat"}).addParametersMatcher(new String[]{"boolean"}).build()});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        int arity = mit.arguments().size();
        for (int i = 0; i < arity; ++i) {
            ExpressionTree booleanArg = (ExpressionTree)mit.arguments().get(i);
            if (!booleanArg.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) continue;
            this.reportIssue((Tree)booleanArg, "Remove or correct this assertion.");
            break;
        }
    }
}

