/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractCallToDeprecatedCodeChecker;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5738")
public class CallToDeprecatedCodeMarkedForRemovalCheck
extends AbstractCallToDeprecatedCodeChecker {
    private static final String MESSAGE = "Remove this call to a deprecated %s, it has been marked for removal.";

    @Override
    void checkDeprecatedIdentifier(IdentifierTree identifierTree, Symbol deprecatedSymbol) {
        if (!this.isFlaggedForRemoval(deprecatedSymbol)) {
            return;
        }
        String deprecatedCode = "code";
        if (deprecatedSymbol.isMethodSymbol()) {
            deprecatedCode = "method";
        } else if (deprecatedSymbol.isTypeSymbol()) {
            deprecatedCode = "class";
        } else if (deprecatedSymbol.isVariableSymbol()) {
            deprecatedCode = "field";
        }
        this.reportIssue((Tree)identifierTree, String.format(MESSAGE, deprecatedCode));
    }

    @Override
    void checkOverridingMethod(MethodTree methodTree, Symbol.MethodSymbol deprecatedSymbol) {
        if (!this.isFlaggedForRemoval((Symbol)deprecatedSymbol)) {
            return;
        }
        this.reportIssue((Tree)methodTree.simpleName(), "Don't override this deprecated method, it has been marked for removal.");
    }
}

