/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2141")
public class ClassWithoutHashCodeInHashStructureCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers EQUALS_MATCHER = MethodMatchers.create().ofAnyType().names(new String[]{"equals"}).addParametersMatcher(new String[]{"java.lang.Object"}).build();
    private static final MethodMatchers HASHCODE_MATCHER = MethodMatchers.create().ofAnyType().names(new String[]{"hashCode"}).addWithoutParametersMatcher().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        Symbol.TypeSymbol symbol;
        if (!this.hasSemantic()) {
            return;
        }
        Type type = ((NewClassTree)tree).symbolType();
        if (type.isParameterized() && ClassWithoutHashCodeInHashStructureCheck.useHashDataStructure(type) && ClassWithoutHashCodeInHashStructureCheck.implementsEquals(symbol = ((Type)type.typeArguments().get(0)).symbol()) && !ClassWithoutHashCodeInHashStructureCheck.implementsHashCode(symbol)) {
            this.reportIssue(tree, "Add a \"hashCode()\" method to \"" + symbol.name() + "\" or remove it from this hash.");
        }
    }

    private static boolean useHashDataStructure(Type type) {
        return type.isSubtypeOf("java.util.HashMap") || type.isSubtypeOf("java.util.HashSet") || type.isSubtypeOf("java.util.Hashtable");
    }

    private static boolean implementsEquals(Symbol.TypeSymbol symbol) {
        return symbol.lookupSymbols("equals").stream().anyMatch(arg_0 -> ((MethodMatchers)EQUALS_MATCHER).matches(arg_0));
    }

    private static boolean implementsHashCode(Symbol.TypeSymbol symbol) {
        return symbol.lookupSymbols("hashCode").stream().anyMatch(arg_0 -> ((MethodMatchers)HASHCODE_MATCHER).matches(arg_0));
    }
}

