/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1607")
public class IgnoredTestsCheck
extends IssuableSubscriptionVisitor {
    private static final String ORG_JUNIT_ASSUME = "org.junit.Assume";
    private static final String BOOLEAN_TYPE = "boolean";
    private static final MethodMatchers ASSUME_METHODS = MethodMatchers.create().ofTypes(new String[]{"org.junit.Assume"}).names(new String[]{"assumeTrue", "assumeFalse"}).addParametersMatcher(new String[]{"boolean"}).build();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        BlockTree block;
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        SymbolMetadata symbolMetadata = methodTree.symbol().metadata();
        if (IgnoredTestsCheck.isSilentlyIgnored(symbolMetadata, "org.junit.Ignore") || IgnoredTestsCheck.isSilentlyIgnored(symbolMetadata, "org.junit.jupiter.api.Disabled")) {
            this.reportIssue((Tree)methodTree.simpleName(), "Fix or remove this skipped unit test");
        }
        if ((block = methodTree.block()) != null) {
            block.body().stream().filter(s -> s.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})).map(s -> ((ExpressionStatementTree)s).expression()).filter(s -> s.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})).map(MethodInvocationTree.class::cast).filter(arg_0 -> ((MethodMatchers)ASSUME_METHODS).matches(arg_0)).filter(IgnoredTestsCheck::hasConstantOppositeArg).forEach(mit -> this.reportIssue((Tree)mit.methodSelect(), "Fix or remove this skipped unit test"));
        }
    }

    private static boolean isSilentlyIgnored(SymbolMetadata symbolMetadata, String annotation) {
        List annotationValues = symbolMetadata.valuesForAnnotation(annotation);
        return annotationValues != null && annotationValues.isEmpty();
    }

    private static boolean hasConstantOppositeArg(MethodInvocationTree mit) {
        Optional result = ((ExpressionTree)mit.arguments().get(0)).asConstant(Boolean.class);
        return result.isPresent() && !((Boolean)result.get()).equals(mit.symbol().name().contains("True"));
    }
}

