/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S3973")
public class IndentationAfterConditionalCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitIfStatement(IfStatementTree tree) {
        Tree parentTree = tree.parent();
        if (parentTree.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) && tree.equals(((IfStatementTree)parentTree).elseStatement())) {
            this.checkForReport(tree.thenStatement(), (Tree)((IfStatementTree)parentTree).elseKeyword(), (Tree)tree.closeParenToken(), tree.ifKeyword().firstToken().text());
        } else {
            this.checkForReport(tree.thenStatement(), (Tree)tree.ifKeyword(), (Tree)tree.closeParenToken(), tree.ifKeyword().text());
        }
        SyntaxToken elseKeyword = tree.elseKeyword();
        if (elseKeyword != null && !tree.elseStatement().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            this.checkForReport(tree.elseStatement(), (Tree)elseKeyword, (Tree)elseKeyword, elseKeyword.firstToken().text());
        }
        super.visitIfStatement(tree);
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        super.visitWhileStatement(tree);
        this.checkForReport(tree.statement(), (Tree)tree.whileKeyword(), (Tree)tree.closeParenToken(), tree.whileKeyword().text());
    }

    public void visitForStatement(ForStatementTree tree) {
        super.visitForStatement(tree);
        this.checkForReport(tree.statement(), (Tree)tree.forKeyword(), (Tree)tree.closeParenToken(), tree.forKeyword().text());
    }

    public void visitForEachStatement(ForEachStatement tree) {
        super.visitForEachStatement(tree);
        this.checkForReport(tree.statement(), (Tree)tree.forKeyword(), (Tree)tree.closeParenToken(), tree.forKeyword().text());
    }

    private void checkForReport(StatementTree statement, Tree startTree, Tree endTree, String name) {
        if (!statement.is(new Tree.Kind[]{Tree.Kind.BLOCK}) && statement.firstToken().column() <= startTree.firstToken().column()) {
            this.context.reportIssue((JavaCheck)this, startTree, endTree, "Use indentation to denote the code conditionally executed by this \"" + name + "\".", Collections.singletonList(new JavaFileScannerContext.Location("", (Tree)statement)), null);
        }
    }
}

