/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2122")
public class ScheduledThreadPoolExecutorZeroCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Increase the \"corePoolSize\".";

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"java.util.concurrent.ThreadPoolExecutor"}).names(new String[]{"setCorePoolSize"}).addParametersMatcher(new String[]{"int"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.util.concurrent.ScheduledThreadPoolExecutor"}).constructor().addParametersMatcher(new String[]{"int"}).build()});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree arg = (ExpressionTree)mit.arguments().get(0);
        if (ScheduledThreadPoolExecutorZeroCheck.isZeroIntLiteral(arg)) {
            this.reportIssue((Tree)arg, MESSAGE);
        }
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        ExpressionTree arg = (ExpressionTree)newClassTree.arguments().get(0);
        if (ScheduledThreadPoolExecutorZeroCheck.isZeroIntLiteral(arg)) {
            this.reportIssue((Tree)arg, MESSAGE);
        }
    }

    private static boolean isZeroIntLiteral(ExpressionTree arg) {
        return arg.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL}) && "0".equals(((LiteralTree)arg).value());
    }
}

