/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4507")
public class DebugFeatureEnabledCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Make sure this debug feature is deactivated before delivering the code in production.";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.ANNOTATION);
    }

    public void visitNode(Tree tree) {
        AnnotationTree annotation = (AnnotationTree)tree;
        if (annotation.symbolType().is("org.springframework.security.config.annotation.web.configuration.EnableWebSecurity")) {
            annotation.arguments().stream().map(DebugFeatureEnabledCheck::getDebugArgument).filter(Objects::nonNull).findFirst().filter(assignment -> Boolean.TRUE.equals(ExpressionsHelper.getConstantValueAsBoolean(assignment.expression()).value())).ifPresent(assignment -> this.reportIssue((Tree)assignment, MESSAGE));
        }
    }

    @CheckForNull
    private static AssignmentExpressionTree getDebugArgument(ExpressionTree expression) {
        AssignmentExpressionTree assignment;
        if (expression.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && (assignment = (AssignmentExpressionTree)expression).variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "debug".equals(((IdentifierTree)assignment.variable()).name())) {
            return assignment;
        }
        return null;
    }
}

