/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3749")
public class SpringComponentWithNonAutowiredMembersCheck
extends IssuableSubscriptionVisitor {
    @RuleProperty(key="customInjectionAnnotations", description="comma-separated list of FQDN annotation names to consider as valid", defaultValue="")
    public String customInjectionAnnotations = "";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree clazzTree = (ClassTree)tree;
        SymbolMetadata clazzMeta = clazzTree.symbol().metadata();
        Set<Symbol> symbolsUsedInConstructors = this.symbolsUsedInConstructors(clazzTree);
        if (SpringComponentWithNonAutowiredMembersCheck.isSpringComponent(clazzMeta)) {
            clazzTree.members().stream().filter(v -> v.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(m -> (VariableTree)m).filter(v -> !v.symbol().isStatic()).filter(v -> !SpringComponentWithNonAutowiredMembersCheck.isSpringInjectionAnnotated(v.symbol().metadata())).filter(v -> !this.isCustomInjectionAnnotated(v.symbol().metadata())).filter(v -> !symbolsUsedInConstructors.contains(v.symbol())).forEach(v -> this.reportIssue((Tree)v.simpleName(), "Annotate this member with \"@Autowired\", \"@Resource\", \"@Inject\", or \"@Value\", or remove it."));
        }
    }

    private static boolean isSpringInjectionAnnotated(SymbolMetadata metadata) {
        return metadata.isAnnotatedWith("org.springframework.beans.factory.annotation.Autowired") || metadata.isAnnotatedWith("javax.inject.Inject") || metadata.isAnnotatedWith("javax.annotation.Resource") || metadata.isAnnotatedWith("org.springframework.beans.factory.annotation.Value");
    }

    private boolean isCustomInjectionAnnotated(SymbolMetadata metadata) {
        return Splitter.on((String)",").trimResults().splitToList((CharSequence)this.customInjectionAnnotations).stream().anyMatch(arg_0 -> ((SymbolMetadata)metadata).isAnnotatedWith(arg_0));
    }

    private static boolean isSpringComponent(SymbolMetadata clazzMeta) {
        return clazzMeta.isAnnotatedWith("org.springframework.stereotype.Controller") || clazzMeta.isAnnotatedWith("org.springframework.stereotype.Service") || clazzMeta.isAnnotatedWith("org.springframework.stereotype.Component") || clazzMeta.isAnnotatedWith("org.springframework.stereotype.Repository");
    }

    private Set<Symbol> symbolsUsedInConstructors(ClassTree clazzTree) {
        List<Symbol.MethodSymbol> constructors = SpringComponentWithNonAutowiredMembersCheck.constructors(clazzTree);
        return constructors.stream().filter(ctor -> this.isAutowired(constructors, (Symbol.MethodSymbol)ctor)).map(Symbol.MethodSymbol::declaration).flatMap(ctorTree -> SpringComponentWithNonAutowiredMembersCheck.symbolsUsedInMethod(ctorTree.symbol()).stream()).collect(Collectors.toSet());
    }

    private boolean isAutowired(List<Symbol.MethodSymbol> constructors, Symbol.MethodSymbol ctor) {
        return SpringComponentWithNonAutowiredMembersCheck.isSpringInjectionAnnotated(ctor.metadata()) || this.isCustomInjectionAnnotated(ctor.metadata()) || constructors.size() == 1;
    }

    private static Set<Symbol> symbolsUsedInMethod(Symbol.MethodSymbol methodSymbol) {
        IdentifierCollector identifierCollector = new IdentifierCollector();
        methodSymbol.declaration().accept((TreeVisitor)identifierCollector);
        return identifierCollector.identifiers;
    }

    private static List<Symbol.MethodSymbol> constructors(ClassTree clazzTree) {
        return clazzTree.symbol().memberSymbols().stream().filter(Symbol::isMethodSymbol).map(s -> (Symbol.MethodSymbol)s).filter(m -> m.name().equals("<init>")).filter(m -> m.declaration() != null).collect(Collectors.toList());
    }

    private static class IdentifierCollector
    extends BaseTreeVisitor {
        Set<Symbol> identifiers = new HashSet<Symbol>();

        private IdentifierCollector() {
        }

        public void visitIdentifier(IdentifierTree tree) {
            this.identifiers.add(tree.symbol());
        }
    }
}

