/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.filters.EclipseI18NFilter;
import org.sonar.java.filters.GeneratedCodeFilter;
import org.sonar.java.filters.JavaIssueFilter;
import org.sonar.java.filters.LombokFilter;
import org.sonar.java.filters.SonarJavaIssueFilter;
import org.sonar.java.filters.SuppressWarningFilter;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide
public class PostAnalysisIssueFilter
implements JavaFileScanner,
SonarJavaIssueFilter {
    private static final Iterable<JavaIssueFilter> DEFAULT_ISSUE_FILTERS = ImmutableList.of((Object)new EclipseI18NFilter(), (Object)new LombokFilter(), (Object)new SuppressWarningFilter(), (Object)new GeneratedCodeFilter());
    private Iterable<JavaIssueFilter> issueFilers;

    @VisibleForTesting
    void setIssueFilters(Iterable<? extends JavaIssueFilter> issueFilters) {
        this.issueFilers = ImmutableList.builder().addAll(issueFilters).build();
    }

    @VisibleForTesting
    Iterable<JavaIssueFilter> getIssueFilters() {
        if (this.issueFilers == null) {
            this.issueFilers = DEFAULT_ISSUE_FILTERS;
        }
        return this.issueFilers;
    }

    public boolean accept(RuleKey ruleKey, AnalyzerMessage analyzerMessage) {
        for (JavaIssueFilter javaIssueFilter : this.getIssueFilters()) {
            if (javaIssueFilter.accept(ruleKey, analyzerMessage)) continue;
            return false;
        }
        return true;
    }

    public void scanFile(JavaFileScannerContext context) {
        for (JavaIssueFilter javaIssueFilter : this.getIssueFilters()) {
            javaIssueFilter.scanFile(context);
        }
    }
}

