/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Rule;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.checks.CheckList;
import org.sonar.java.checks.SuppressWarningsCheck;
import org.sonar.java.filters.BaseTreeVisitorIssueFilter;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

public class SuppressWarningFilter
extends BaseTreeVisitorIssueFilter {
    private static final Multimap<String, String> JAVAC_WARNING_SUPPRESSING_RULES = new ImmutableMultimap.Builder().put((Object)"cast", (Object)"java:S1905").put((Object)"deprecation", (Object)"java:S1874").put((Object)"dep-ann", (Object)"java:S1123").put((Object)"divzero", (Object)"java:S3518").putAll((Object)"empty", (Object[])new String[]{"java:S1116", "java:S108"}).put((Object)"fallthrough", (Object)"java:S128").put((Object)"finally", (Object)"java:S1143").put((Object)"overrides", (Object)"java:S1206").put((Object)"removal", (Object)"java:S5738").put((Object)"serial", (Object)"java:S2057").put((Object)"static", (Object)"java:S2209").build();
    private final Map<String, Multimap<String, Integer>> excludedLinesByComponent = new HashMap<String, Multimap<String, Integer>>();
    private static final String SUPPRESS_WARNING_RULE_KEY = SuppressWarningFilter.getSuppressWarningRuleKey();
    private static final Map<String, RuleKey> DEPRRECATED_RULE_KEYS = SuppressWarningFilter.getDeprecatedRuleKeys();

    private static String getSuppressWarningRuleKey() {
        return ((Rule)AnnotationUtils.getAnnotation(SuppressWarningsCheck.class, Rule.class)).key();
    }

    @Override
    public Set<Class<? extends JavaCheck>> filteredRules() {
        return Collections.emptySet();
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        this.excludedLinesByComponent.put(this.getComponentKey(), (Multimap<String, Integer>)HashMultimap.create(this.excludedLinesByRule()));
    }

    private static Map<String, RuleKey> getDeprecatedRuleKeys() {
        HashMap<String, RuleKey> deprecatedRuleKeys = new HashMap<String, RuleKey>();
        CheckList.getChecks().forEach(c -> {
            String key = ((Rule)AnnotationUtils.getAnnotation((Object)c, Rule.class)).key();
            DeprecatedRuleKey deprecatedRuleKeyAnnotation = (DeprecatedRuleKey)AnnotationUtils.getAnnotation((Object)c, DeprecatedRuleKey.class);
            if (deprecatedRuleKeyAnnotation != null) {
                deprecatedRuleKeys.put(key, RuleKey.of((String)deprecatedRuleKeyAnnotation.repositoryKey(), (String)deprecatedRuleKeyAnnotation.ruleKey()));
            }
        });
        return deprecatedRuleKeys;
    }

    @Override
    public boolean accept(RuleKey ruleKey, AnalyzerMessage analyzerMessage) {
        Multimap<String, Integer> excludedLinesByRule = HashMultimap.create();
        String componentKey = analyzerMessage.getInputComponent().key();
        if (this.excludedLinesByComponent.containsKey(componentKey)) {
            excludedLinesByRule = this.excludedLinesByComponent.get(componentKey);
        }
        return !SuppressWarningFilter.issueShouldNotBeReported(ruleKey, analyzerMessage, excludedLinesByRule);
    }

    private static boolean issueShouldNotBeReported(RuleKey issueRuleKey, AnalyzerMessage analyzerMessage, Multimap<String, Integer> excludedLineByRule) {
        for (String excludedRule : excludedLineByRule.keySet()) {
            Collection excludedLines;
            if (!"all".equals(excludedRule) && !SuppressWarningFilter.isRuleKey(excludedRule, issueRuleKey) || SuppressWarningFilter.isSuppressWarningRule(issueRuleKey) || !(excludedLines = excludedLineByRule.get((Object)excludedRule)).contains(analyzerMessage.getLine())) continue;
            return true;
        }
        return false;
    }

    private static boolean isRuleKey(String rule, RuleKey ruleKey) {
        try {
            RuleKey parsed = RuleKey.parse((String)rule);
            RuleKey deprecatedRuleKey = DEPRRECATED_RULE_KEYS.get(ruleKey.rule());
            RuleKey squidRuleKey = RuleKey.of((String)"squid", (String)ruleKey.rule());
            return ruleKey.equals((Object)parsed) || squidRuleKey.equals((Object)parsed) || parsed.equals((Object)deprecatedRuleKey);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static boolean isSuppressWarningRule(RuleKey ruleKey) {
        return SUPPRESS_WARNING_RULE_KEY.equals(ruleKey.rule());
    }

    public void visitClass(ClassTree tree) {
        this.handleSuppressWarning(tree.modifiers().annotations(), (Tree)tree);
        super.visitClass(tree);
    }

    public void visitMethod(MethodTree tree) {
        this.handleSuppressWarning(tree.modifiers().annotations(), (Tree)tree);
        super.visitMethod(tree);
    }

    public void visitVariable(VariableTree tree) {
        this.handleSuppressWarning(tree.modifiers().annotations(), (Tree)tree);
        super.visitVariable(tree);
    }

    private void handleSuppressWarning(List<AnnotationTree> annotationTrees, Tree tree) {
        int startLine = -1;
        ArrayList<String> rules = new ArrayList<String>();
        for (AnnotationTree annotationTree : annotationTrees) {
            if (!SuppressWarningFilter.isSuppressWarningsAnnotation(annotationTree)) continue;
            startLine = SuppressWarningFilter.startLineIncludingTrivia(tree);
            rules.addAll(SuppressWarningFilter.getRules(annotationTree));
            break;
        }
        if (startLine != -1) {
            int endLine = tree.lastToken().line();
            ContiguousSet filteredlines = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(startLine), (Comparable)Integer.valueOf(endLine)), (DiscreteDomain)DiscreteDomain.integers());
            for (String rule : rules) {
                this.excludeLines((Set<Integer>)filteredlines, rule);
            }
        }
    }

    private static int startLineIncludingTrivia(Tree tree) {
        SyntaxToken firstToken = tree.firstToken();
        if (!firstToken.trivias().isEmpty()) {
            return ((SyntaxTrivia)firstToken.trivias().get(0)).startLine();
        }
        return firstToken.line();
    }

    private static boolean isSuppressWarningsAnnotation(AnnotationTree annotationTree) {
        return annotationTree.annotationType().symbolType().is("java.lang.SuppressWarnings") && !annotationTree.arguments().isEmpty();
    }

    private static List<String> getRules(AnnotationTree annotationTree) {
        return SuppressWarningFilter.getRulesFromExpression((ExpressionTree)annotationTree.arguments().get(0));
    }

    private static List<String> getRulesFromExpression(ExpressionTree expression) {
        ArrayList<String> args = new ArrayList<String>();
        if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            for (ExpressionTree initializer : ((NewArrayTree)expression).initializers()) {
                args.addAll(SuppressWarningFilter.getRulesFromExpression(initializer));
            }
        } else {
            expression.asConstant(String.class).ifPresent(rule -> {
                if (JAVAC_WARNING_SUPPRESSING_RULES.containsKey(rule)) {
                    args.addAll(JAVAC_WARNING_SUPPRESSING_RULES.get(rule));
                } else {
                    args.add((String)rule);
                }
            });
        }
        return args;
    }
}

