/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.java.regex.RegexCheck;
import org.sonar.java.regex.ast.CharacterTree;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.java.regex.ast.RegexTree;

public class RegexTreeHelper {
    private static final Pattern MARK_PATTERN = Pattern.compile("\\p{M}");

    private RegexTreeHelper() {
    }

    public static List<RegexCheck.RegexIssueLocation> getGraphemeInList(List<RegexTree> trees) {
        ArrayList<RegexCheck.RegexIssueLocation> result = new ArrayList<RegexCheck.RegexIssueLocation>();
        RegexTree startGrapheme = null;
        RegexTree endGrapheme = null;
        for (RegexTree child : trees) {
            CharacterTree currentCharacter;
            if (child.is(new RegexTree.Kind[]{RegexTree.Kind.PLAIN_CHARACTER, RegexTree.Kind.UNICODE_CODE_POINT}) && !(currentCharacter = (CharacterTree)child).isEscapeSequence()) {
                if (!RegexTreeHelper.isMark(currentCharacter)) {
                    RegexTreeHelper.addCurrentGrapheme(result, startGrapheme, endGrapheme);
                    startGrapheme = child;
                    endGrapheme = null;
                    continue;
                }
                if (startGrapheme == null) continue;
                endGrapheme = child;
                continue;
            }
            RegexTreeHelper.addCurrentGrapheme(result, startGrapheme, endGrapheme);
            startGrapheme = null;
            endGrapheme = null;
        }
        RegexTreeHelper.addCurrentGrapheme(result, startGrapheme, endGrapheme);
        return result;
    }

    private static boolean isMark(CharacterTree currentChar) {
        return MARK_PATTERN.matcher(currentChar.characterAsString()).matches();
    }

    private static void addCurrentGrapheme(List<RegexCheck.RegexIssueLocation> result, @Nullable RegexSyntaxElement start, @Nullable RegexSyntaxElement end) {
        if (start != null && end != null) {
            result.add(new RegexCheck.RegexIssueLocation(start, end, ""));
        }
    }
}

