/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2970")
public class AssertionsCompletenessCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String FEST_ASSERT_SUPERTYPE = "org.fest.assertions.Assert";
    private static final String ASSERTJ_SUPERTYPE = "org.assertj.core.api.AbstractAssert";
    private static final String TRUTH_SUPERTYPE = "com.google.common.truth.TestVerb";
    private static final String JAVA6_ABSTRACT_SOFT_ASSERT = "org.assertj.core.api.Java6AbstractStandardSoftAssertions";
    private static final MethodMatchers MOCKITO_VERIFY = MethodMatchers.create().ofSubTypes(new String[]{"org.mockito.Mockito"}).names(new String[]{"verify"}).withAnyParameters().build();
    private static final MethodMatchers ASSERTJ_ASSERT_ALL = MethodMatchers.create().ofSubTypes(new String[]{"org.assertj.core.api.SoftAssertions", "org.assertj.core.api.Java6SoftAssertions"}).names(new String[]{"assertAll"}).withAnyParameters().build();
    private static final MethodMatchers ASSERTJ_ASSERT_THAT = MethodMatchers.create().ofSubTypes(new String[]{"org.assertj.core.api.AbstractSoftAssertions"}).name(name -> name.startsWith("assertThat")).withAnyParameters().build();
    private static final MethodMatchers ASSERTJ_ASSERT_SOFTLY = MethodMatchers.create().ofSubTypes(new String[]{"org.assertj.core.api.SoftAssertions"}).names(new String[]{"assertSoftly"}).withAnyParameters().build();
    private static final MethodMatchers FEST_LIKE_ASSERT_THAT = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"org.fest.assertions.Assertions", "org.fest.assertions.api.Assertions", "org.assertj.core.api.AbstractSoftAssertions", "org.assertj.core.api.Assertions", "org.assertj.core.api.Java6Assertions", "org.assertj.core.api.AbstractStandardSoftAssertions", "org.assertj.core.api.Java6AbstractStandardSoftAssertions", "org.assertj.core.api.StrictAssertions"}).names(new String[]{"assertThat"}).addParametersMatcher(new String[]{"*"}).build(), MethodMatchers.create().ofTypes(new String[]{"org.assertj.core.api.Assertions"}).names(new String[]{"assertThatObject", "assertThatCode", "assertThatExceptionOfType", "assertThatNullPointerException", "assertThatIllegalArgumentException", "assertThatIOException", "assertThatIllegalStateException"}).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"com.google.common.truth.Truth", "com.google.common.truth.Truth8"}).name(name -> name.startsWith("assert")).addParametersMatcher(new String[]{"*"}).build()});
    private static final Pattern FEST_LIKE_EXCLUSION_NAMES = Pattern.compile("as.*+|using.*+|with.*+|describedAs|overridingErrorMessage|extracting");
    private static final MethodMatchers FEST_LIKE_EXCLUSIONS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"org.fest.assertions.Assert", "org.assertj.core.api.AbstractAssert"}).name(name -> FEST_LIKE_EXCLUSION_NAMES.matcher((CharSequence)name).matches()).withAnyParameters().build(), MethodMatchers.create().ofSubTypes(new String[]{"com.google.common.truth.TestVerb"}).names(new String[]{"that"}).withAnyParameters().build()});
    private Boolean chainedToAnyMethodButFestExclusions = null;
    private JavaFileScannerContext context;

    private static boolean isMethodCalledOnJava6AbstractStandardSoftAssertions(MethodInvocationTree mit) {
        Type type;
        ExpressionTree methodSelect = mit.methodSelect();
        return methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (type = ((MemberSelectExpressionTree)methodSelect).expression().symbolType()).is(JAVA6_ABSTRACT_SOFT_ASSERT);
    }

    public void scanFile(JavaFileScannerContext context) {
        if (context.getSemanticModel() == null) {
            return;
        }
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
    }

    public void visitMethod(MethodTree methodTree) {
        if (ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.ABSTRACT)) {
            return;
        }
        super.visitMethod(methodTree);
        if (UnitTestUtils.hasTestAnnotation(methodTree)) {
            SoftAssertionsVisitor softAssertionsVisitor = new SoftAssertionsVisitor();
            methodTree.accept((TreeVisitor)softAssertionsVisitor);
            if (softAssertionsVisitor.assertThatCalled && !AssertionsCompletenessCheck.isSoftAssertionsExtension(methodTree)) {
                this.context.reportIssue((JavaCheck)this, (Tree)methodTree.block().closeBraceToken(), "Add a call to 'assertAll' after all 'assertThat'.");
            }
        }
    }

    private static boolean isSoftAssertionsExtension(MethodTree methodTree) {
        List annotationValues;
        Symbol owner = methodTree.symbol().owner();
        if (owner != null && owner.isTypeSymbol() && (annotationValues = owner.metadata().valuesForAnnotation("org.junit.jupiter.api.extension.ExtendWith")) != null) {
            return annotationValues.stream().anyMatch(av -> AssertionsCompletenessCheck.isSoftAssertionsExtensionClass(av.value()));
        }
        return false;
    }

    private static boolean isSoftAssertionsExtensionClass(Object value) {
        if (value instanceof Object[]) {
            Object[] values;
            for (Object v : values = (Object[])value) {
                if (!(v instanceof Symbol) || !((Symbol)v).type().is("org.assertj.core.api.junit.jupiter.SoftAssertionsExtension")) continue;
                return true;
            }
        }
        return false;
    }

    public void visitMethodInvocation(MethodInvocationTree mit) {
        if (this.incompleteAssertion(mit)) {
            return;
        }
        Boolean previous = this.chainedToAnyMethodButFestExclusions;
        this.chainedToAnyMethodButFestExclusions = (Boolean)MoreObjects.firstNonNull((Object)this.chainedToAnyMethodButFestExclusions, (Object)false) != false || !FEST_LIKE_EXCLUSIONS.matches(mit);
        this.scan((Tree)mit.methodSelect());
        this.chainedToAnyMethodButFestExclusions = previous;
    }

    private boolean incompleteAssertion(MethodInvocationTree mit) {
        if (AssertionsCompletenessCheck.isMethodCalledOnJava6AbstractStandardSoftAssertions(mit)) {
            return false;
        }
        if ((FEST_LIKE_ASSERT_THAT.matches(mit) || MOCKITO_VERIFY.matches(mit)) && !Boolean.TRUE.equals(this.chainedToAnyMethodButFestExclusions)) {
            this.context.reportIssue((JavaCheck)this, (Tree)mit.methodSelect(), "Complete the assertion.");
            return true;
        }
        return false;
    }

    class SoftAssertionsVisitor
    extends BaseTreeVisitor {
        private boolean assertThatCalled;
        private final List<MethodInvocationTree> intermediateMethodInvocations;

        public SoftAssertionsVisitor() {
            this(false, Collections.emptyList());
        }

        public SoftAssertionsVisitor(boolean assertThatCalled, List<MethodInvocationTree> intermediateMethodInvocations) {
            this.assertThatCalled = assertThatCalled;
            this.intermediateMethodInvocations = intermediateMethodInvocations;
        }

        public void visitNewClass(NewClassTree tree) {
            if (tree.symbolType().is(AssertionsCompletenessCheck.JAVA6_ABSTRACT_SOFT_ASSERT)) {
                AssertionsCompletenessCheck.this.context.reportIssue((JavaCheck)AssertionsCompletenessCheck.this, (Tree)tree, "Use 'Java6SoftAssertions' instead of 'Java6AbstractStandardSoftAssertions'.");
                return;
            }
            super.visitNewClass(tree);
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (AssertionsCompletenessCheck.isMethodCalledOnJava6AbstractStandardSoftAssertions(mit)) {
                return;
            }
            boolean assertThatStateBeforeInvocation = this.assertThatCalled;
            super.visitMethodInvocation(mit);
            if (ASSERTJ_ASSERT_SOFTLY.matches(mit)) {
                this.assertThatCalled = assertThatStateBeforeInvocation;
            }
            if (ASSERTJ_ASSERT_ALL.matches(mit)) {
                if (this.assertThatCalled) {
                    this.assertThatCalled = false;
                } else {
                    List allLocations = Stream.concat(this.intermediateMethodInvocations.stream(), Stream.of(mit)).collect(Collectors.toList());
                    MethodInvocationTree mainLocation = (MethodInvocationTree)allLocations.get(0);
                    List secondaries = allLocations.stream().skip(1L).map(methodInvocation -> new JavaFileScannerContext.Location("", (Tree)methodInvocation.methodSelect())).collect(Collectors.toList());
                    AssertionsCompletenessCheck.this.context.reportIssue((JavaCheck)AssertionsCompletenessCheck.this, (Tree)mainLocation, "Add one or more 'assertThat' before 'assertAll'.", secondaries, null);
                }
            } else if (ASSERTJ_ASSERT_THAT.matches(mit) && !this.isJUnitSoftAssertions(mit)) {
                this.assertThatCalled = true;
            } else if (mit.symbol().declaration() != null && this.intermediateMethodInvocations.stream().noneMatch(intermediate -> intermediate.symbol().equals(mit.symbol()))) {
                List<MethodInvocationTree> allLocations = Stream.concat(this.intermediateMethodInvocations.stream(), Stream.of(mit)).collect(Collectors.toList());
                SoftAssertionsVisitor softAssertionsVisitor = new SoftAssertionsVisitor(this.assertThatCalled, allLocations);
                mit.symbol().declaration().accept((TreeVisitor)softAssertionsVisitor);
                this.assertThatCalled = softAssertionsVisitor.assertThatCalled;
            }
        }

        public void visitTryStatement(TryStatementTree tree) {
            boolean hasAutoCloseableSoftAssertion = tree.resourceList().stream().map(this::resourceSymbol).map(Symbol::type).filter(Objects::nonNull).anyMatch(type -> type.isSubtypeOf("org.assertj.core.api.AutoCloseableSoftAssertions"));
            super.visitTryStatement(tree);
            if (hasAutoCloseableSoftAssertion) {
                if (this.assertThatCalled) {
                    this.assertThatCalled = false;
                } else {
                    List secondaries = this.intermediateMethodInvocations.stream().map(methodInvocation -> new JavaFileScannerContext.Location("", (Tree)methodInvocation.methodSelect())).collect(Collectors.toList());
                    AssertionsCompletenessCheck.this.context.reportIssue((JavaCheck)AssertionsCompletenessCheck.this, (Tree)tree.block().closeBraceToken(), "Add one or more 'assertThat' before the end of this try block.", secondaries, null);
                }
            }
        }

        private Symbol resourceSymbol(Tree tree) {
            switch (tree.kind()) {
                case VARIABLE: {
                    return ((VariableTree)tree).symbol();
                }
                case IDENTIFIER: {
                    return ((IdentifierTree)tree).symbol();
                }
                case MEMBER_SELECT: {
                    return ((MemberSelectExpressionTree)tree).identifier().symbol();
                }
            }
            throw new IllegalArgumentException("Tree is not try-with-resources resource");
        }

        private boolean isJUnitSoftAssertions(MethodInvocationTree mit) {
            ExpressionTree expressionTree = mit.methodSelect();
            if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                Type type = ((MemberSelectExpressionTree)expressionTree).expression().symbolType();
                return type.isSubtypeOf("org.assertj.core.api.JUnitSoftAssertions") || type.isSubtypeOf("org.assertj.core.api.Java6JUnitSoftAssertions");
            }
            return false;
        }
    }
}

