/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.InputFileScannerContext;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.internal.EndOfAnalysis;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;

public abstract class AbstractPackageInfoChecker
implements JavaFileScanner,
EndOfAnalysis {
    private static final Logger LOG = Loggers.get(AbstractPackageInfoChecker.class);
    private static final String CACHE_KEY_PREFIX = "java:S1228;S4032:package:";

    private static String cacheKey(InputFile inputFile) {
        return CACHE_KEY_PREFIX + inputFile.key();
    }

    protected abstract void processFile(InputFileScannerContext var1, String var2);

    public boolean scanWithoutParsing(InputFileScannerContext inputFileScannerContext) {
        return AbstractPackageInfoChecker.getPackageFromCache(inputFileScannerContext).map(packageName -> {
            this.processFileAndCacheIfApplicable(inputFileScannerContext, (String)packageName);
            return true;
        }).orElse(false);
    }

    public void scanFile(JavaFileScannerContext context) {
        PackageDeclarationTree packageDeclaration = context.getTree().packageDeclaration();
        String packageName = packageDeclaration == null ? null : ExpressionsHelper.concatenate(packageDeclaration.packageName());
        this.processFileAndCacheIfApplicable((InputFileScannerContext)context, packageName);
    }

    private void processFileAndCacheIfApplicable(InputFileScannerContext context, @Nullable String packageName) {
        if (context.getCacheContext().isCacheEnabled()) {
            AbstractPackageInfoChecker.writePackageNameToCache(context, packageName == null ? "" : packageName);
        }
        if (packageName == null || packageName.isEmpty()) {
            return;
        }
        this.processFile(context, packageName);
    }

    protected static Optional<String> getPackageFromCache(InputFileScannerContext inputFileScannerContext) {
        String cacheKey = AbstractPackageInfoChecker.cacheKey(inputFileScannerContext.getInputFile());
        byte[] bytes = inputFileScannerContext.getCacheContext().getReadCache().readBytes(cacheKey);
        return bytes != null ? Optional.of(new String(bytes, StandardCharsets.UTF_8)) : Optional.empty();
    }

    protected static void writePackageNameToCache(InputFileScannerContext context, String packageName) {
        String cacheKey = AbstractPackageInfoChecker.cacheKey(context.getInputFile());
        try {
            context.getCacheContext().getWriteCache().write(cacheKey, packageName.getBytes(StandardCharsets.UTF_8));
        }
        catch (IllegalArgumentException e) {
            LOG.trace(() -> String.format("Could not store data to cache key '%s': %s", cacheKey, e.getMessage()));
        }
    }
}

