/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3986")
public class DateFormatWeekYearCheck
extends AbstractMethodDetection {
    private static final MethodMatchers SIMPLE_DATE_FORMAT_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.text.SimpleDateFormat"}).constructor().withAnyParameters().build();
    private static final MethodMatchers OF_PATTERN_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.time.format.DateTimeFormatter"}).names(new String[]{"ofPattern"}).addParametersMatcher(new String[]{"java.lang.String"}).addParametersMatcher(new String[]{"java.lang.String", "java.util.Locale"}).build();
    private static final String RECOMMENDATION_YEAR_MESSAGE = "Make sure that week Year \"%s\" is expected here instead of Year \"%s\".";

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{SIMPLE_DATE_FORMAT_MATCHER, OF_PATTERN_MATCHER});
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        if (newClassTree.arguments().isEmpty()) {
            return;
        }
        ExpressionTree expressionTree = (ExpressionTree)newClassTree.arguments().get(0);
        this.inspectPattern(expressionTree);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree invocation) {
        Arguments arguments = invocation.arguments();
        if (arguments.isEmpty()) {
            return;
        }
        ExpressionTree argument = (ExpressionTree)arguments.get(0);
        this.inspectPattern(argument);
    }

    private void inspectPattern(ExpressionTree argument) {
        Optional literal = argument.asConstant(String.class);
        if (!literal.isPresent()) {
            return;
        }
        String datePattern = (String)literal.get();
        if (StringUtils.contains((CharSequence)datePattern, (int)119)) {
            return;
        }
        int start = datePattern.indexOf(89);
        if (start > -1) {
            int end = DateFormatWeekYearCheck.getEndIndexOfYearSequence(datePattern, start);
            String firstYSeq = datePattern.substring(start, end);
            String replacement = firstYSeq.toLowerCase(Locale.ENGLISH);
            String message = String.format(RECOMMENDATION_YEAR_MESSAGE, firstYSeq, replacement);
            InternalJavaIssueBuilder issueBuilder = QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)argument).withMessage(message);
            if (argument.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
                issueBuilder.withQuickFix(() -> DateFormatWeekYearCheck.computeQuickFix(argument, start, end, replacement));
            }
            issueBuilder.report();
        }
    }

    private static int getEndIndexOfYearSequence(String sequence, int start) {
        int count;
        for (count = start; count < sequence.length() && sequence.charAt(count) == 'Y'; ++count) {
        }
        return count;
    }

    private static JavaQuickFix computeQuickFix(ExpressionTree argument, int literalContentStartIndex, int literalContentEndIndex, String replacement) {
        Position stringLiteralStart = argument.firstToken().range().start();
        int quoteDelimiterLength = 1;
        return JavaQuickFix.newQuickFix((String)"Replace year format").addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)new AnalyzerMessage.TextSpan(stringLiteralStart.line(), stringLiteralStart.columnOffset() + quoteDelimiterLength + literalContentStartIndex, stringLiteralStart.line(), stringLiteralStart.columnOffset() + quoteDelimiterLength + literalContentEndIndex), (String)replacement)}).build();
    }
}

