/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1641")
public class EnumSetCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers COLLECTIONS_UNMODIFIABLE = MethodMatchers.create().ofTypes(new String[]{"java.util.Collections"}).names(new String[]{"unmodifiableSet"}).withAnyParameters().build();
    private static final MethodMatchers SET_CREATION_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.util.Set"}).names(new String[]{"of"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"com.google.common.collect.ImmutableSet"}).names(new String[]{"of"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"com.google.common.collect.Sets"}).anyName().withAnyParameters().build()});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.VARIABLE);
    }

    public void visitNode(Tree tree) {
        VariableTree variableTree = (VariableTree)tree;
        ExpressionTree initializer = variableTree.initializer();
        if (initializer == null) {
            return;
        }
        if (initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)initializer;
            if (COLLECTIONS_UNMODIFIABLE.matches(mit)) {
                initializer = (ExpressionTree)mit.arguments().get(0);
            } else if (!SET_CREATION_METHODS.matches(mit) || "immutableEnumSet".equals(mit.symbol().name())) {
                return;
            }
        }
        if (!initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS})) {
            return;
        }
        this.checkIssue(initializer.symbolType(), (Tree)initializer);
    }

    private void checkIssue(Type type, Tree reportTree) {
        Type typeArgument;
        if (type.isSubtypeOf("java.util.Set") && !type.isSubtypeOf("java.util.EnumSet") && type.isParameterized() && (typeArgument = (Type)type.typeArguments().get(0)) != null && typeArgument.symbol().isEnum()) {
            this.reportIssue(reportTree, "Convert this Set to an EnumSet.");
        }
    }
}

