/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3740")
public class RawTypeCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree tree) {
        Boolean overridesParentMethod = tree.isOverriding();
        if (overridesParentMethod == null || Boolean.TRUE.equals(overridesParentMethod)) {
            this.scan((Tree)tree.block());
        } else {
            this.checkTypeTree(tree.returnType());
            super.visitMethod(tree);
        }
    }

    public void visitParameterizedType(ParameterizedTypeTree tree) {
        tree.typeArguments().forEach(this::checkTypeTree);
        super.visitParameterizedType(tree);
    }

    public void visitNewClass(NewClassTree tree) {
        this.checkTypeTree(tree.identifier());
        super.visitNewClass(tree);
    }

    public void visitVariable(VariableTree tree) {
        this.checkTypeTree(tree.type());
        super.visitVariable(tree);
    }

    public void visitClass(ClassTree tree) {
        tree.superInterfaces().forEach(this::checkTypeTree);
        this.checkTypeTree(tree.superClass());
        super.visitClass(tree);
    }

    private void checkTypeTree(@Nullable TypeTree typeTree) {
        if (typeTree == null) {
            return;
        }
        if (typeTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.checkIdentifier((IdentifierTree)typeTree);
        } else if (typeTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            this.checkIdentifier(((MemberSelectExpressionTree)typeTree).identifier());
        }
    }

    private void checkIdentifier(IdentifierTree identifier) {
        Type type = identifier.symbolType();
        if (JUtils.isRawType((Type)type) && !type.equals(JUtils.declaringType((Type)type))) {
            this.context.reportIssue((JavaCheck)this, (Tree)identifier, "Provide the parametrized type for this generic.");
        }
    }
}

