/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2325")
public class StaticMethodCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String JAVA_IO_SERIALIZABLE = "java.io.Serializable";
    private static final MethodMatchers EXCLUDED_SERIALIZABLE_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"java.io.Serializable"}).names(new String[]{"readObject"}).addParametersMatcher(params -> params.size() == 1 && ((Type)params.get(0)).isSubtypeOf("java.io.ObjectInputStream")).build(), MethodMatchers.create().ofSubTypes(new String[]{"java.io.Serializable"}).names(new String[]{"writeObject"}).addParametersMatcher(params -> params.size() == 1 && ((Type)params.get(0)).isSubtypeOf("java.io.ObjectOutputStream")).build(), MethodMatchers.create().ofSubTypes(new String[]{"java.io.Serializable"}).names(new String[]{"readObjectNoData", "writeReplace", "readResolve"}).addWithoutParametersMatcher().build()});
    private JavaFileScannerContext context;
    private Deque<MethodReference> methodReferences = new LinkedList<MethodReference>();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitMethod(MethodTree tree) {
        if (StaticMethodCheck.isExcluded(tree)) {
            return;
        }
        Symbol.MethodSymbol symbol = tree.symbol();
        this.methodReferences.push(new MethodReference(symbol));
        this.scan(tree.parameters());
        this.scan((Tree)tree.block());
        MethodReference reference = this.methodReferences.pop();
        ClassTree classTree = (ClassTree)tree.parent();
        if (!Boolean.FALSE.equals(tree.isOverriding()) || classTree.is(new Tree.Kind[]{Tree.Kind.ENUM})) {
            return;
        }
        if ((symbol.isPrivate() || symbol.isFinal() || classTree.symbol().isFinal()) && !symbol.isStatic() && !reference.hasNonStaticReference()) {
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)tree.simpleName()).withMessage("Make \"%s\" a \"static\" method.", new Object[]{symbol.name()}).withQuickFix(() -> StaticMethodCheck.getQuickFix(tree)).report();
        }
    }

    private static JavaQuickFix getQuickFix(MethodTree tree) {
        SyntaxToken insertPosition = QuickFixHelper.nextToken((Tree)tree.modifiers());
        for (ModifierKeywordTree modifier : tree.modifiers().modifiers()) {
            if (!StaticMethodCheck.shouldBePlacedAfterStatic(modifier.modifier())) continue;
            insertPosition = modifier;
            break;
        }
        return JavaQuickFix.newQuickFix((String)"Make static").addTextEdit(new JavaTextEdit[]{JavaTextEdit.insertBeforeTree((Tree)insertPosition, (String)"static ")}).build();
    }

    private static boolean shouldBePlacedAfterStatic(Modifier modifier) {
        return modifier.ordinal() > Modifier.STATIC.ordinal();
    }

    private static boolean isExcluded(MethodTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) || EXCLUDED_SERIALIZABLE_METHODS.matches(tree) || StaticMethodCheck.hasEmptyBody(tree);
    }

    private static boolean hasEmptyBody(MethodTree tree) {
        return tree.block() != null && tree.block().body().isEmpty();
    }

    public void visitIdentifier(IdentifierTree tree) {
        MemberSelectExpressionTree parent;
        super.visitIdentifier(tree);
        if ("class".equals(tree.name()) || this.methodReferences.isEmpty()) {
            return;
        }
        if (StaticMethodCheck.parentIs((Tree)tree, Tree.Kind.MEMBER_SELECT) && tree.equals((parent = (MemberSelectExpressionTree)tree.parent()).identifier()) && !StaticMethodCheck.parentIs((Tree)parent, Tree.Kind.NEW_CLASS) && !StaticMethodCheck.refToEnclosingClass(tree)) {
            return;
        }
        this.visitTerminalIdentifier(tree);
    }

    private static boolean refToEnclosingClass(IdentifierTree tree) {
        String identifier = tree.name();
        return "this".equals(identifier) || "super".equals(identifier);
    }

    private void visitTerminalIdentifier(IdentifierTree tree) {
        Symbol symbol = tree.symbol();
        MethodReference currentMethod = this.methodReferences.peek();
        if (symbol.isUnknown()) {
            currentMethod.setNonStaticReference();
            return;
        }
        for (MethodReference methodReference : this.methodReferences) {
            methodReference.checkSymbol(symbol);
        }
    }

    private static boolean parentIs(Tree tree, Tree.Kind kind) {
        return tree.parent() != null && tree.parent().is(new Tree.Kind[]{kind});
    }

    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        IdentifierTree identifier;
        Symbol owner;
        if (tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (owner = (identifier = (IdentifierTree)tree.expression()).symbol().owner()) != null && owner.isMethodSymbol()) {
            return;
        }
        super.visitMemberSelectExpression(tree);
    }

    private static class MethodReference {
        private final Symbol.MethodSymbol methodSymbol;
        private final Symbol methodScopeOwner;
        private boolean nonStaticReference = false;

        MethodReference(Symbol.MethodSymbol symbol) {
            this.methodSymbol = symbol;
            this.methodScopeOwner = this.methodSymbol.owner();
            if (this.methodScopeOwner != null && this.methodScopeOwner.isTypeSymbol()) {
                this.nonStaticReference = !this.methodScopeOwner.isStatic() && !this.methodScopeOwner.owner().isPackageSymbol();
            }
        }

        @CheckForNull
        private static Symbol getPackage(Symbol symbol) {
            Symbol owner;
            for (owner = symbol.owner(); owner != null && !owner.isPackageSymbol(); owner = owner.owner()) {
            }
            return owner;
        }

        void setNonStaticReference() {
            this.nonStaticReference = true;
        }

        boolean hasNonStaticReference() {
            return this.nonStaticReference;
        }

        void checkSymbol(Symbol symbol) {
            if (this.nonStaticReference || this.methodSymbol.equals(symbol) || symbol.isStatic()) {
                return;
            }
            Symbol scopeOwner = symbol.owner();
            if (MethodReference.isConstructor(symbol)) {
                this.checkConstructor(scopeOwner);
            } else if (scopeOwner != null) {
                this.checkNonConstructor(scopeOwner);
            }
        }

        private void checkConstructor(Symbol constructorClass) {
            Symbol constructorPackage;
            Symbol methodPackage;
            if (!constructorClass.isStatic() && Objects.equals(methodPackage = MethodReference.getPackage(this.methodScopeOwner), constructorPackage = MethodReference.getPackage(constructorClass)) && !constructorClass.owner().isPackageSymbol()) {
                this.setNonStaticReference();
            }
        }

        private void checkNonConstructor(Symbol scopeOwner) {
            if (scopeOwner.isMethodSymbol()) {
                return;
            }
            if (MethodReference.hasLocalAccess(this.methodScopeOwner, scopeOwner)) {
                this.setNonStaticReference();
            }
        }

        private static boolean isConstructor(Symbol symbol) {
            return "<init>".equals(symbol.name());
        }

        private static boolean hasLocalAccess(Symbol scope, Symbol symbol) {
            Type symbolType;
            Type scopeType;
            if (scope.equals(symbol)) {
                return true;
            }
            return scope.isTypeSymbol() && symbol.isTypeSymbol() && (scopeType = scope.type().erasure()).isSubtypeOf(symbolType = symbol.type().erasure());
        }
    }
}

