/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.finders.ComplexRegexFinder;

@Rule(key="S5843")
public class RegexComplexityCheck
extends AbstractRegexCheck {
    private static final int DEFAULT_MAX = 20;
    @RuleProperty(key="maxComplexity", description="The maximum authorized complexity.", defaultValue="20")
    private int max = 20;
    private final List<RegexConstructionInfo> regexConstructions = new ArrayList<RegexConstructionInfo>();
    private final Set<Integer> commentedLines = new HashSet<Integer>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        ArrayList<Tree.Kind> nodes = new ArrayList<Tree.Kind>(super.nodesToVisit());
        nodes.add(Tree.Kind.TRIVIA);
        return nodes;
    }

    @Override
    public void checkRegex(RegexParseResult parseResult, ExpressionTree methodInvocationOrAnnotation) {
        ExpressionTree regexArgument = this.getRegexLiteralExpression(methodInvocationOrAnnotation);
        this.regexConstructions.add(new RegexConstructionInfo(regexArgument, parseResult.getInitialFlags(), parseResult.containsComments()));
    }

    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
        this.commentedLines.add(syntaxTrivia.range().start().line());
        int numLines = StringUtils.countMatches((CharSequence)syntaxTrivia.comment(), (CharSequence)"\n");
        if (numLines > 0) {
            this.commentedLines.add(syntaxTrivia.range().start().line() + numLines);
        }
    }

    public void leaveFile(JavaFileScannerContext context) {
        for (RegexConstructionInfo regexInfo : this.regexConstructions) {
            FlagSet flags = regexInfo.initialFlags;
            for (LiteralTree[] regexPart : this.findRegexParts(regexInfo)) {
                new ComplexRegexFinder(this::reportIssueFromCommons, this.max).visit(this.regexForLiterals(flags, regexPart));
            }
        }
        this.regexConstructions.clear();
        this.commentedLines.clear();
    }

    List<LiteralTree[]> findRegexParts(RegexConstructionInfo regexInfo) {
        RegexPartFinder finder = new RegexPartFinder(regexInfo.initialFlags, regexInfo.containsComments);
        finder.find(regexInfo.regexArgument);
        return finder.parts;
    }

    public void setMax(int max) {
        this.max = max;
    }

    private static class RegexConstructionInfo {
        final ExpressionTree regexArgument;
        final FlagSet initialFlags;
        final boolean containsComments;

        RegexConstructionInfo(ExpressionTree regexArgument, FlagSet initialFlags, boolean containsComments) {
            this.regexArgument = regexArgument;
            this.initialFlags = initialFlags;
            this.containsComments = containsComments;
        }
    }

    private class RegexPartFinder {
        final FlagSet initialFlags;
        final boolean regexContainsComments;
        List<LiteralTree[]> parts = new ArrayList<LiteralTree[]>();

        RegexPartFinder(FlagSet initialFlags, boolean regexContainsComments) {
            this.initialFlags = initialFlags;
            this.regexContainsComments = regexContainsComments;
        }

        void find(ExpressionTree expr) {
            switch (expr.kind()) {
                case PLUS: {
                    ArrayList<LiteralTree> literals = new ArrayList<LiteralTree>();
                    this.findInStringConcatenation(expr, literals);
                    if (literals.isEmpty()) break;
                    this.parts.add(literals.toArray(new LiteralTree[0]));
                    break;
                }
                case IDENTIFIER: {
                    AbstractRegexCheck.getFinalVariableInitializer((IdentifierTree)expr).ifPresent(this::find);
                    break;
                }
                case PARENTHESIZED_EXPRESSION: {
                    this.find(ExpressionUtils.skipParentheses((ExpressionTree)expr));
                    break;
                }
                case STRING_LITERAL: {
                    this.parts.add(new LiteralTree[]{(LiteralTree)expr});
                    break;
                }
            }
        }

        void findInStringConcatenation(ExpressionTree expr, List<LiteralTree> literals) {
            if (expr.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
                LiteralTree literal = (LiteralTree)expr;
                if (this.isCommented(literal)) {
                    this.parts.add(new LiteralTree[]{literal});
                } else {
                    literals.add(literal);
                }
            } else if (expr.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
                BinaryExpressionTree binExpr = (BinaryExpressionTree)expr;
                this.findInStringConcatenation(binExpr.leftOperand(), literals);
                this.findInStringConcatenation(binExpr.rightOperand(), literals);
            } else if (expr.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
                this.findInStringConcatenation(ExpressionUtils.skipParentheses((ExpressionTree)expr), literals);
            } else {
                this.find(expr);
            }
        }

        private boolean isCommented(LiteralTree regexPart) {
            int line = regexPart.token().range().start().line();
            return this.regexContainsComments || RegexComplexityCheck.this.commentedLines.contains(line) || RegexComplexityCheck.this.commentedLines.contains(line - 1);
        }
    }
}

