/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2612")
public class FilePermissionsCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String ISSUE_MESSAGE = "Make sure this permission is safe.";
    private static final Set<String> POSIX_OTHER_PERMISSIONS = new HashSet<String>(Arrays.asList("OTHERS_READ", "OTHERS_WRITE", "OTHERS_EXECUTE"));
    private static final MethodMatchers POSIX_FILE_PERMISSIONS_FROM_STRING = MethodMatchers.create().ofTypes(new String[]{"java.nio.file.attribute.PosixFilePermissions"}).names(new String[]{"fromString"}).addParametersMatcher(new String[]{"java.lang.String"}).build();
    private static final MethodMatchers RUNTIME_EXEC = MethodMatchers.create().ofTypes(new String[]{"java.lang.Runtime"}).names(new String[]{"exec"}).withAnyParameters().build();
    private static final Pattern CHMOD_OCTAL_PATTERN = Pattern.compile("(^|\\s)[0-7]{2,3}[1-7](\\s|$)");
    private static final String WHO = "([ug]*+[ao][ugao]*+)?";
    private static final String WHAT = "[+=]";
    private static final String WHICH = "[sStT]*+[rwxX][rwxXsStT]*+";
    private static final Pattern SIMPLIFIED_CHMOD_OTHER_PATTERN = Pattern.compile("(^|\\s|,)([ug]*+[ao][ugao]*+)?[+=][sStT]*+[rwxX][rwxXsStT]*+(\\s|,|$)");

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.IDENTIFIER, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.checkIdentifier((IdentifierTree)tree);
        } else {
            this.checkMethodInvocation((MethodInvocationTree)tree);
        }
    }

    private void checkIdentifier(IdentifierTree identifier) {
        if (FilePermissionsCheck.isPosixPermission(identifier) && FilePermissionsCheck.isBeingAdded(identifier)) {
            this.reportIssue((Tree)identifier, ISSUE_MESSAGE);
        }
    }

    private static boolean isPosixPermission(IdentifierTree identifier) {
        return POSIX_OTHER_PERMISSIONS.contains(identifier.name()) && identifier.symbolType().isSubtypeOf("java.nio.file.attribute.PosixFilePermission");
    }

    private static boolean isBeingAdded(IdentifierTree identifier) {
        for (Tree parent = identifier.parent(); parent != null; parent = parent.parent()) {
            String methodName;
            if (!parent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) || !(methodName = ((MethodInvocationTree)parent).symbol().name()).contains("add")) continue;
            return true;
        }
        return false;
    }

    private void checkMethodInvocation(MethodInvocationTree mit) {
        if (POSIX_FILE_PERMISSIONS_FROM_STRING.matches(mit)) {
            ExpressionTree arg0 = (ExpressionTree)mit.arguments().get(0);
            if (FilePermissionsCheck.sensitivePermissionsAsString(arg0)) {
                this.reportIssue((Tree)arg0, ISSUE_MESSAGE);
            }
        } else if (RUNTIME_EXEC.matches(mit)) {
            ExpressionTree arg0 = (ExpressionTree)mit.arguments().get(0);
            Type arg0Type = arg0.symbolType();
            if (arg0Type.is(JAVA_LANG_STRING)) {
                this.checkExecSingleStringArgument(arg0);
            } else if (arg0Type.is("java.lang.String[]") && arg0.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
                this.checkExecStringArrayArgument((NewArrayTree)arg0);
            }
        }
    }

    private static boolean sensitivePermissionsAsString(ExpressionTree arg0) {
        return arg0.asConstant(String.class).filter(chmod -> chmod.length() == 9).filter(chmod -> !chmod.endsWith("---")).isPresent();
    }

    private void checkExecSingleStringArgument(ExpressionTree arg0) {
        if (FilePermissionsCheck.chmodCommand(arg0).filter(FilePermissionsCheck::isSensitiveChmodMode).isPresent()) {
            this.reportIssue((Tree)arg0, ISSUE_MESSAGE);
        }
    }

    private void checkExecStringArrayArgument(NewArrayTree newArrayTree) {
        ListTree initializers = newArrayTree.initializers();
        if (initializers.size() < 3 || !FilePermissionsCheck.chmodCommand((ExpressionTree)initializers.get(0)).isPresent()) {
            return;
        }
        for (int i = 1; i < initializers.size(); ++i) {
            ExpressionTree arg = (ExpressionTree)initializers.get(i);
            if (!arg.asConstant(String.class).filter(FilePermissionsCheck::isSensitiveChmodMode).isPresent()) continue;
            this.reportIssue((Tree)arg, ISSUE_MESSAGE);
        }
    }

    private static Optional<String> chmodCommand(ExpressionTree expr) {
        return expr.asConstant(String.class).filter(cmd -> cmd.contains("chmod"));
    }

    private static boolean isSensitiveChmodMode(String mode) {
        return CHMOD_OCTAL_PATTERN.matcher(mode).find() || SIMPLIFIED_CHMOD_OTHER_PATTERN.matcher(mode).find();
    }
}

