/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.Rule;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.checks.helpers.CredentialMethod;
import org.sonar.java.checks.helpers.CredentialMethodsLoader;
import org.sonar.java.checks.helpers.ReassignmentFinder;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6437")
public class HardCodedCredentialsShouldNotBeUsedCheck
extends IssuableSubscriptionVisitor {
    public static final String CREDENTIALS_METHODS_FILE = "/org/sonar/java/checks/security/S6437-methods.json";
    private static final Logger LOG = Loggers.get(HardCodedCredentialsShouldNotBeUsedCheck.class);
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final MethodMatchers STRING_TO_ARRAY_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"getBytes", "toLowerCase", "toUpperCase"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"toCharArray", "trim", "strip", "stripIndent", "stripLeading", "stripTrailing", "intern", "translateEscapes"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"subSequence", "substring"}).addParametersMatcher(new String[]{"int"}).addParametersMatcher(new String[]{"int", "int"}).build(), MethodMatchers.create().ofAnyType().names(new String[]{"toString"}).addWithoutParametersMatcher().build()});
    private static final MethodMatchers SUPPORTED_CONSTRUCTORS = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).constructor().addParametersMatcher(parameters -> !parameters.isEmpty()).build();
    private static final String ISSUE_MESSAGE = "Revoke and change this password, as it is compromised.";
    private Map<String, List<CredentialMethod>> methods;

    public HardCodedCredentialsShouldNotBeUsedCheck() {
        this(CREDENTIALS_METHODS_FILE);
    }

    @VisibleForTesting
    HardCodedCredentialsShouldNotBeUsedCheck(String resourcePath) {
        try {
            this.methods = CredentialMethodsLoader.load(resourcePath);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            this.methods = Collections.emptyMap();
        }
    }

    public Map<String, List<CredentialMethod>> getMethods() {
        return this.methods;
    }

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        String methodName;
        boolean isConstructor = tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS});
        if (isConstructor) {
            NewClassTree newClass = (NewClassTree)tree;
            methodName = newClass.symbolType().name();
        } else {
            MethodInvocationTree invocation = (MethodInvocationTree)tree;
            methodName = invocation.symbol().name();
        }
        List<CredentialMethod> candidates = this.methods.get(methodName);
        if (candidates == null) {
            return;
        }
        for (CredentialMethod candidate : candidates) {
            MethodMatchers matcher = candidate.methodMatcher();
            if (isConstructor) {
                NewClassTree constructor = (NewClassTree)tree;
                if (!matcher.matches(constructor)) continue;
                this.checkArguments(constructor.arguments(), candidate);
                continue;
            }
            MethodInvocationTree invocation = (MethodInvocationTree)tree;
            if (!matcher.matches(invocation)) continue;
            this.checkArguments(invocation.arguments(), candidate);
        }
    }

    private void checkArguments(Arguments arguments, CredentialMethod method) {
        for (int targetArgumentIndex : method.indices) {
            ArrayList<JavaFileScannerContext.Location> secondaryLocations;
            ExpressionTree argument = (ExpressionTree)arguments.get(targetArgumentIndex);
            if (!HardCodedCredentialsShouldNotBeUsedCheck.isExpressionDerivedFromPlainText(argument, secondaryLocations = new ArrayList<JavaFileScannerContext.Location>(), new HashSet<Symbol>())) continue;
            this.reportIssue((Tree)argument, ISSUE_MESSAGE, secondaryLocations, null);
        }
    }

    private static boolean isExpressionDerivedFromPlainText(ExpressionTree expression, List<JavaFileScannerContext.Location> secondaryLocations, Set<Symbol> visited) {
        ExpressionTree arg = ExpressionUtils.skipParentheses((ExpressionTree)expression);
        switch (arg.kind()) {
            case IDENTIFIER: {
                IdentifierTree identifier = (IdentifierTree)arg;
                return HardCodedCredentialsShouldNotBeUsedCheck.isDerivedFromPlainText(identifier, secondaryLocations, visited);
            }
            case NEW_ARRAY: {
                NewArrayTree newArrayTree = (NewArrayTree)arg;
                return HardCodedCredentialsShouldNotBeUsedCheck.isDerivedFromPlainText(newArrayTree, secondaryLocations, visited);
            }
            case NEW_CLASS: {
                NewClassTree newClassTree = (NewClassTree)arg;
                return HardCodedCredentialsShouldNotBeUsedCheck.isDerivedFromPlainText(newClassTree, secondaryLocations, visited);
            }
            case METHOD_INVOCATION: {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)arg;
                return HardCodedCredentialsShouldNotBeUsedCheck.isDerivedFromPlainText(methodInvocationTree, secondaryLocations, visited);
            }
            case CONDITIONAL_EXPRESSION: {
                ConditionalExpressionTree conditionalTree = (ConditionalExpressionTree)arg;
                return HardCodedCredentialsShouldNotBeUsedCheck.isDerivedFromPlainText(conditionalTree, secondaryLocations, visited);
            }
            case MEMBER_SELECT: {
                MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)arg;
                return HardCodedCredentialsShouldNotBeUsedCheck.isDerivedFromPlainText(memberSelect.identifier(), secondaryLocations, visited);
            }
            case STRING_LITERAL: {
                return !LiteralUtils.isEmptyString((Tree)arg);
            }
            case TYPE_CAST: {
                TypeCastTree typeCast = (TypeCastTree)arg;
                return HardCodedCredentialsShouldNotBeUsedCheck.isExpressionDerivedFromPlainText(typeCast.expression(), secondaryLocations, visited);
            }
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case DOUBLE_LITERAL: 
            case FLOAT_LITERAL: 
            case INT_LITERAL: 
            case LONG_LITERAL: {
                return true;
            }
        }
        if (arg instanceof BinaryExpressionTree) {
            BinaryExpressionTree binaryExpression = (BinaryExpressionTree)arg;
            return HardCodedCredentialsShouldNotBeUsedCheck.isDerivedFromPlainText(binaryExpression, secondaryLocations, visited);
        }
        return false;
    }

    private static boolean isDerivedFromPlainText(BinaryExpressionTree binaryExpression, List<JavaFileScannerContext.Location> secondaryLocations, Set<Symbol> visited) {
        return HardCodedCredentialsShouldNotBeUsedCheck.isExpressionDerivedFromPlainText(binaryExpression.rightOperand(), secondaryLocations, visited) && HardCodedCredentialsShouldNotBeUsedCheck.isExpressionDerivedFromPlainText(binaryExpression.leftOperand(), secondaryLocations, visited);
    }

    private static boolean isDerivedFromPlainText(IdentifierTree identifier, List<JavaFileScannerContext.Location> secondaryLocations, Set<Symbol> visited) {
        boolean identifierIsDerivedFromPlainText;
        Symbol symbol = identifier.symbol();
        boolean firstVisit = visited.add(symbol);
        if (!firstVisit || !symbol.isVariableSymbol() || JUtils.isParameter((Symbol)symbol) || HardCodedCredentialsShouldNotBeUsedCheck.isNonFinalField(symbol)) {
            return false;
        }
        VariableTree variable = (VariableTree)symbol.declaration();
        if (variable == null) {
            return JUtils.constantValue((Symbol.VariableSymbol)((Symbol.VariableSymbol)symbol)).isPresent();
        }
        ExpressionTree initializer = variable.initializer();
        ArrayList assignments = new ArrayList();
        Optional.ofNullable(initializer).ifPresent(assignments::add);
        ReassignmentFinder.getReassignments((Tree)variable, symbol.usages()).stream().map(AssignmentExpressionTree::expression).forEach(assignments::add);
        boolean bl = identifierIsDerivedFromPlainText = !assignments.isEmpty() && assignments.stream().allMatch(expression -> HardCodedCredentialsShouldNotBeUsedCheck.isExpressionDerivedFromPlainText(expression, secondaryLocations, visited));
        if (identifierIsDerivedFromPlainText) {
            secondaryLocations.add(new JavaFileScannerContext.Location("", (Tree)variable));
            return true;
        }
        return false;
    }

    private static boolean isNonFinalField(Symbol symbol) {
        return symbol.isVariableSymbol() && symbol.owner().isTypeSymbol() && !symbol.isFinal();
    }

    private static boolean isDerivedFromPlainText(NewArrayTree invocation, List<JavaFileScannerContext.Location> secondaryLocations, Set<Symbol> visited) {
        ListTree initializers = invocation.initializers();
        return !initializers.isEmpty() && initializers.stream().allMatch(expression -> HardCodedCredentialsShouldNotBeUsedCheck.isExpressionDerivedFromPlainText(expression, secondaryLocations, visited));
    }

    private static boolean isDerivedFromPlainText(NewClassTree invocation, List<JavaFileScannerContext.Location> secondaryLocations, Set<Symbol> visited) {
        return SUPPORTED_CONSTRUCTORS.matches(invocation) && HardCodedCredentialsShouldNotBeUsedCheck.isExpressionDerivedFromPlainText((ExpressionTree)invocation.arguments().get(0), secondaryLocations, visited);
    }

    private static boolean isDerivedFromPlainText(MethodInvocationTree invocation, List<JavaFileScannerContext.Location> secondaryLocations, Set<Symbol> visited) {
        if (!STRING_TO_ARRAY_METHODS.matches(invocation)) {
            return false;
        }
        ExpressionTree methodSelect = ExpressionUtils.skipParentheses((ExpressionTree)invocation.methodSelect());
        return methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && HardCodedCredentialsShouldNotBeUsedCheck.isExpressionDerivedFromPlainText(((MemberSelectExpressionTree)methodSelect).expression(), secondaryLocations, visited);
    }

    private static boolean isDerivedFromPlainText(ConditionalExpressionTree conditionalTree, List<JavaFileScannerContext.Location> secondaryLocations, Set<Symbol> visited) {
        return HardCodedCredentialsShouldNotBeUsedCheck.isExpressionDerivedFromPlainText(conditionalTree.trueExpression(), secondaryLocations, visited) && HardCodedCredentialsShouldNotBeUsedCheck.isExpressionDerivedFromPlainText(conditionalTree.falseExpression(), secondaryLocations, visited);
    }
}

