/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2229")
public class SpringIncompatibleTransactionalCheck
extends IssuableSubscriptionVisitor {
    private static final String SPRING_TRANSACTIONAL_ANNOTATION = "org.springframework.transaction.annotation.Transactional";
    private static final String JAVAX_TRANSACTIONAL_ANNOTATION = "javax.transaction.Transactional";
    private static final String MANDATORY = "MANDATORY";
    private static final String NESTED = "NESTED";
    private static final String NEVER = "NEVER";
    private static final String NOT_SUPPORTED = "NOT_SUPPORTED";
    private static final String REQUIRED = "REQUIRED";
    private static final String REQUIRES_NEW = "REQUIRES_NEW";
    private static final String SUPPORTS = "SUPPORTS";
    private static final String NOT_TRANSACTIONAL = "SONAR_NOT_TRANSACTIONAL";
    private static final Map<String, Set<String>> INCOMPATIBLE_PROPAGATION_MAP = SpringIncompatibleTransactionalCheck.buildIncompatiblePropagationMap();

    private static Map<String, Set<String>> buildIncompatiblePropagationMap() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put(NOT_TRANSACTIONAL, new HashSet<String>(Arrays.asList(MANDATORY, NESTED, REQUIRED, REQUIRES_NEW)));
        map.put(MANDATORY, new HashSet<String>(Arrays.asList(NESTED, NEVER, NOT_SUPPORTED, REQUIRES_NEW)));
        map.put(NESTED, new HashSet<String>(Arrays.asList(NESTED, NEVER, NOT_SUPPORTED, REQUIRES_NEW)));
        map.put(NEVER, new HashSet<String>(Arrays.asList(MANDATORY, NESTED, REQUIRED, REQUIRES_NEW)));
        map.put(NOT_SUPPORTED, new HashSet<String>(Arrays.asList(MANDATORY, NESTED, REQUIRED, REQUIRES_NEW)));
        map.put(REQUIRED, new HashSet<String>(Arrays.asList(NESTED, NEVER, NOT_SUPPORTED, REQUIRES_NEW)));
        map.put(REQUIRES_NEW, new HashSet<String>(Arrays.asList(NESTED, NEVER, NOT_SUPPORTED, REQUIRES_NEW)));
        map.put(SUPPORTS, new HashSet<String>(Arrays.asList(MANDATORY, NESTED, NEVER, NOT_SUPPORTED, REQUIRED, REQUIRES_NEW)));
        return map;
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Map<Symbol, String> methodsPropagationMap = SpringIncompatibleTransactionalCheck.collectMethodsPropagation(classTree);
        if (SpringIncompatibleTransactionalCheck.hasSameValues(methodsPropagationMap.values())) {
            return;
        }
        methodsPropagationMap.forEach((symbol, propagation) -> this.checkMethodInvocations((MethodTree)symbol.declaration(), (String)propagation, methodsPropagationMap));
    }

    private void checkMethodInvocations(MethodTree method, final @Nullable String callerPropagation, final Map<Symbol, String> methodsPropagationMap) {
        BlockTree methodBody = method.block();
        if (methodBody == null) {
            return;
        }
        methodBody.accept((TreeVisitor)new BaseTreeVisitor(){

            public void visitMethodInvocation(MethodInvocationTree methodInvocation) {
                super.visitMethodInvocation(methodInvocation);
                Symbol calleeMethodSymbol = methodInvocation.symbol();
                if (calleeMethodSymbol.isUnknown()) {
                    return;
                }
                if (methodsPropagationMap.containsKey(calleeMethodSymbol) && SpringIncompatibleTransactionalCheck.methodInvocationOnThisInstance(methodInvocation)) {
                    String calleePropagation = (String)methodsPropagationMap.get(calleeMethodSymbol);
                    SpringIncompatibleTransactionalCheck.this.checkIncompatiblePropagation(methodInvocation, callerPropagation, calleeMethodSymbol, calleePropagation);
                }
            }
        });
    }

    private static boolean methodInvocationOnThisInstance(MethodInvocationTree methodInvocation) {
        if (methodInvocation.symbol().isStatic()) {
            return false;
        }
        ExpressionTree expression = methodInvocation.methodSelect();
        if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return ExpressionUtils.isThis((ExpressionTree)((MemberSelectExpressionTree)expression).expression());
        }
        return expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER});
    }

    private void checkIncompatiblePropagation(MethodInvocationTree methodInvocation, @Nullable String callerPropagation, Symbol calleeMethodSymbol, String calleePropagation) {
        Set incompatiblePropagation = INCOMPATIBLE_PROPAGATION_MAP.getOrDefault(callerPropagation, Collections.emptySet());
        if (incompatiblePropagation.contains(calleePropagation)) {
            String message = "\"" + calleeMethodSymbol.name() + "'s\" @Transactional requirement is incompatible with the one for this method.";
            List<JavaFileScannerContext.Location> secondaryLocations = Collections.singletonList(new JavaFileScannerContext.Location("Incompatible method definition.", (Tree)((MethodTree)calleeMethodSymbol.declaration()).simpleName()));
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)methodInvocation), message, secondaryLocations, null);
        }
    }

    private static Map<Symbol, String> collectMethodsPropagation(ClassTree classTree) {
        HashMap<Symbol, String> methodPropagationMap = new HashMap<Symbol, String>();
        SpringIncompatibleTransactionalCheck.getPropagationIfKnown((Symbol)classTree.symbol(), NOT_TRANSACTIONAL).ifPresent(classPropagation -> {
            for (Tree member : classTree.members()) {
                MethodTree method;
                if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD}) || !(method = (MethodTree)member).symbol().isPublic()) continue;
                SpringIncompatibleTransactionalCheck.getPropagationIfKnown((Symbol)method.symbol(), classPropagation).ifPresent(propagation -> methodPropagationMap.put((Symbol)method.symbol(), (String)propagation));
            }
        });
        return methodPropagationMap;
    }

    private static boolean hasSameValues(Collection<String> methodsPropagationList) {
        return methodsPropagationList.stream().distinct().count() <= 1L;
    }

    private static Optional<String> getPropagationIfKnown(Symbol symbol, String inheritedPropagation) {
        String defaultValue = NOT_TRANSACTIONAL.equals(inheritedPropagation) ? REQUIRED : inheritedPropagation;
        Optional<String> propagation = Optional.of(inheritedPropagation);
        for (SymbolMetadata.AnnotationInstance annotationInstance : symbol.metadata().annotations()) {
            Symbol annotationSymbol = annotationInstance.symbol();
            Type annotationType = annotationSymbol.type();
            if (annotationSymbol.isUnknown()) {
                return Optional.empty();
            }
            if (annotationType.is(SPRING_TRANSACTIONAL_ANNOTATION)) {
                propagation = SpringIncompatibleTransactionalCheck.getAnnotationAttributeAsString(annotationInstance.values(), "propagation", defaultValue);
                continue;
            }
            if (!annotationType.is(JAVAX_TRANSACTIONAL_ANNOTATION)) continue;
            propagation = SpringIncompatibleTransactionalCheck.getAnnotationAttributeAsString(annotationInstance.values(), "value", defaultValue);
        }
        return propagation;
    }

    private static Optional<String> getAnnotationAttributeAsString(List<SymbolMetadata.AnnotationValue> values, String attributeName, String defaultValue) {
        for (SymbolMetadata.AnnotationValue annotationValue : values) {
            if (!attributeName.equals(annotationValue.name())) continue;
            Object value = annotationValue.value();
            if (value instanceof Symbol.VariableSymbol) {
                return Optional.of(((Symbol.VariableSymbol)value).name());
            }
            return Optional.empty();
        }
        return Optional.of(defaultValue);
    }
}

