/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S3752")
public class SpringRequestMappingMethodCheck
extends IssuableSubscriptionVisitor {
    private static final String REQUEST_MAPPING_CLASS = "org.springframework.web.bind.annotation.RequestMapping";
    private static final String REQUEST_METHOD = "method";
    public static final String MESSAGE = "Make sure allowing safe and unsafe HTTP methods is safe here.";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        SpringRequestMappingMethodCheck.findRequestMappingAnnotation(classTree.modifiers()).flatMap(SpringRequestMappingMethodCheck::findRequestMethods).filter(SpringRequestMappingMethodCheck::mixSafeAndUnsafeMethods).ifPresent(methods -> this.reportIssue((Tree)methods, MESSAGE));
        classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).forEach(member -> this.checkMethod((MethodTree)member, classTree.symbol()));
    }

    private void checkMethod(MethodTree method, Symbol.TypeSymbol classSymbol) {
        Optional<AnnotationTree> requestMappingAnnotation = SpringRequestMappingMethodCheck.findRequestMappingAnnotation(method.modifiers());
        Optional requestMethods = requestMappingAnnotation.flatMap(SpringRequestMappingMethodCheck::findRequestMethods);
        if (requestMethods.isPresent()) {
            requestMethods.filter(SpringRequestMappingMethodCheck::mixSafeAndUnsafeMethods).ifPresent(methods -> this.reportIssue((Tree)methods, MESSAGE));
        } else if (requestMappingAnnotation.isPresent() && !SpringRequestMappingMethodCheck.inheritRequestMethod(classSymbol)) {
            this.reportIssue((Tree)requestMappingAnnotation.get().annotationType(), MESSAGE);
        }
    }

    private static Optional<AnnotationTree> findRequestMappingAnnotation(ModifiersTree modifiers) {
        return modifiers.annotations().stream().filter(annotation -> annotation.symbolType().is(REQUEST_MAPPING_CLASS)).findFirst();
    }

    private static Optional<ExpressionTree> findRequestMethods(AnnotationTree annotation) {
        return annotation.arguments().stream().filter(argument -> argument.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})).map(AssignmentExpressionTree.class::cast).filter(assignment -> REQUEST_METHOD.equals(((IdentifierTree)assignment.variable()).name())).map(AssignmentExpressionTree::expression).findFirst();
    }

    private static boolean inheritRequestMethod(Symbol.TypeSymbol symbol) {
        List annotationValues = symbol.metadata().valuesForAnnotation(REQUEST_MAPPING_CLASS);
        if (annotationValues != null && annotationValues.stream().anyMatch(value -> REQUEST_METHOD.equals(value.name()))) {
            return true;
        }
        Type superClass = symbol.superClass();
        if (superClass != null && SpringRequestMappingMethodCheck.inheritRequestMethod(superClass.symbol())) {
            return true;
        }
        for (Type type : symbol.interfaces()) {
            if (!SpringRequestMappingMethodCheck.inheritRequestMethod(type.symbol())) continue;
            return true;
        }
        return false;
    }

    private static boolean mixSafeAndUnsafeMethods(ExpressionTree requestMethodsAssignment) {
        HttpMethodVisitor visitor = new HttpMethodVisitor();
        requestMethodsAssignment.accept((TreeVisitor)visitor);
        return visitor.hasSafeMethods && visitor.hasUnsafeMethods;
    }

    private static class HttpMethodVisitor
    extends BaseTreeVisitor {
        private static final Set<String> SAFE_METHODS = new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS", "TRACE"));
        private static final Set<String> UNSAFE_METHODS = new HashSet<String>(Arrays.asList("DELETE", "PATCH", "POST", "PUT"));
        private boolean hasSafeMethods = false;
        private boolean hasUnsafeMethods = false;

        private HttpMethodVisitor() {
        }

        public void visitIdentifier(IdentifierTree tree) {
            this.hasSafeMethods |= SAFE_METHODS.contains(tree.name());
            this.hasUnsafeMethods |= UNSAFE_METHODS.contains(tree.name());
        }
    }
}

