/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S5961")
public class TooManyAssertionsCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAX = 25;
    @RuleProperty(key="MaximumAssertionNumber", description="The maximum authorized number of assertions in a test method", defaultValue="25")
    public int maximum = 25;
    private final Map<Symbol, List<Tree>> assertionsInMethod = new HashMap<Symbol, List<Tree>>();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        List<Tree> assertionsTree;
        int assertionsSize;
        MethodTree methodTree = (MethodTree)tree;
        if (ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.ABSTRACT)) {
            return;
        }
        if (UnitTestUtils.isUnitTest(methodTree) && (assertionsSize = (assertionsTree = this.collectAssertionsInMethod((Symbol)methodTree.symbol())).size()) > this.maximum) {
            List locations = assertionsTree.stream().map(assertionTree -> new JavaFileScannerContext.Location("Assertion", assertionTree)).collect(Collectors.toList());
            this.reportIssue((Tree)methodTree.simpleName(), String.format("Refactor this method to reduce the number of assertions from %d to less than %d.", assertionsSize, this.maximum), locations, null);
        }
    }

    public void leaveFile(JavaFileScannerContext context) {
        this.assertionsInMethod.clear();
        super.leaveFile(context);
    }

    private List<Tree> collectAssertionsInMethod(Symbol symbol) {
        if (!this.assertionsInMethod.containsKey(symbol)) {
            this.assertionsInMethod.put(symbol, Collections.emptyList());
            Tree declaration = symbol.declaration();
            if (declaration != null) {
                AssertionsCounterVisitor assertionsCounterVisitor = new AssertionsCounterVisitor();
                declaration.accept((TreeVisitor)assertionsCounterVisitor);
                this.assertionsInMethod.put(symbol, new ArrayList<Tree>(assertionsCounterVisitor.assertions));
            }
        }
        return this.assertionsInMethod.get(symbol);
    }

    private class AssertionsCounterVisitor
    extends BaseTreeVisitor {
        private final Set<Tree> assertions = new LinkedHashSet<Tree>();
        private final Set<Tree> chainedAssertions = new LinkedHashSet<Tree>();

        private AssertionsCounterVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            super.visitMethodInvocation(mit);
            if (this.isAssertion(ExpressionUtils.methodName((MethodInvocationTree)mit), mit.symbol())) {
                ExpressionTree expression;
                ExpressionTree methodSelect = mit.methodSelect();
                if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (this.assertions.contains(expression = ((MemberSelectExpressionTree)methodSelect).expression()) || this.chainedAssertions.contains(expression))) {
                    this.chainedAssertions.add((Tree)mit);
                    return;
                }
                this.assertions.add((Tree)mit);
            }
        }

        public void visitMethodReference(MethodReferenceTree methodReferenceTree) {
            super.visitMethodReference(methodReferenceTree);
            if (this.isAssertion(methodReferenceTree.method(), methodReferenceTree.method().symbol())) {
                this.assertions.add((Tree)methodReferenceTree);
            }
        }

        private boolean isAssertion(IdentifierTree method, Symbol methodSymbol) {
            return this.matchesAssertionMethodPattern(method, methodSymbol) || UnitTestUtils.ASSERTION_INVOCATION_MATCHERS.matches(methodSymbol) || !TooManyAssertionsCheck.this.collectAssertionsInMethod(methodSymbol).isEmpty();
        }

        private boolean matchesAssertionMethodPattern(IdentifierTree method, Symbol methodSymbol) {
            String methodName = method.name();
            if (UnitTestUtils.TEST_METHODS_PATTERN.matcher(methodName).matches()) {
                return !UnitTestUtils.REACTIVE_X_TEST_METHODS.matches(methodSymbol);
            }
            return UnitTestUtils.ASSERTION_METHODS_PATTERN.matcher(methodName).matches();
        }
    }
}

