/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.cfg.LiveVariables;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.se.ProgramState;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1450")
public class PrivateFieldUsedLocallyCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Remove the \"%s\" field and declare it as a local variable in the relevant methods.";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        Symbol.TypeSymbol classSymbol = ((ClassTree)tree).symbol();
        Set<Symbol> fieldsReadOnAnotherInstance = FieldsReadOnAnotherInstanceVisitor.getFrom(tree);
        classSymbol.memberSymbols().stream().filter(PrivateFieldUsedLocallyCheck::isPrivateField).filter(s -> !s.isFinal() || !s.isStatic()).filter(s -> !PrivateFieldUsedLocallyCheck.hasAnnotation(s)).filter(s -> !s.usages().isEmpty()).filter(s -> !fieldsReadOnAnotherInstance.contains(s)).forEach(s -> this.checkPrivateField((Symbol)s, classSymbol));
    }

    private static boolean hasAnnotation(Symbol s) {
        return !s.metadata().annotations().isEmpty();
    }

    private void checkPrivateField(Symbol privateFieldSymbol, Symbol.TypeSymbol classSymbol) {
        MethodTree methodWhereUsed = PrivateFieldUsedLocallyCheck.usedInOneMethodOnly(privateFieldSymbol, classSymbol);
        if (methodWhereUsed != null && !PrivateFieldUsedLocallyCheck.isLiveInMethodEntry(privateFieldSymbol, methodWhereUsed)) {
            IdentifierTree declarationIdentifier = ((VariableTree)privateFieldSymbol.declaration()).simpleName();
            String message = String.format(MESSAGE, privateFieldSymbol.name());
            this.reportIssue((Tree)declarationIdentifier, message);
        }
    }

    private static boolean isLiveInMethodEntry(Symbol privateFieldSymbol, MethodTree methodTree) {
        CFG cfg = (CFG)methodTree.cfg();
        LiveVariables liveVariables = LiveVariables.analyzeWithFields((CFG)cfg);
        return liveVariables.getIn(cfg.entryBlock()).contains(privateFieldSymbol);
    }

    private static boolean isPrivateField(Symbol memberSymbol) {
        return memberSymbol.isPrivate() && memberSymbol.isVariableSymbol();
    }

    @CheckForNull
    private static MethodTree usedInOneMethodOnly(Symbol privateFieldSymbol, Symbol.TypeSymbol classSymbol) {
        MethodTree method = null;
        for (IdentifierTree usageIdentifier : privateFieldSymbol.usages()) {
            MethodTree enclosingMethod = ExpressionUtils.getEnclosingElement((ExpressionTree)usageIdentifier, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.METHOD});
            if (enclosingMethod == null || !enclosingMethod.symbol().owner().equals((Object)classSymbol) || method != null && !method.equals((Object)enclosingMethod)) {
                return null;
            }
            method = enclosingMethod;
        }
        return method;
    }

    private static class FieldsReadOnAnotherInstanceVisitor
    extends BaseTreeVisitor {
        private Set<Symbol> fieldsReadOnAnotherInstance = new HashSet<Symbol>();

        private FieldsReadOnAnotherInstanceVisitor() {
        }

        static Set<Symbol> getFrom(Tree classTree) {
            FieldsReadOnAnotherInstanceVisitor fieldsReadOnAnotherInstanceVisitor = new FieldsReadOnAnotherInstanceVisitor();
            fieldsReadOnAnotherInstanceVisitor.scan(classTree);
            return fieldsReadOnAnotherInstanceVisitor.fieldsReadOnAnotherInstance;
        }

        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            Symbol symbol = tree.identifier().symbol();
            if (ProgramState.isField((Symbol)symbol) && !symbol.isStatic()) {
                if (tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                    if (!ExpressionUtils.isThis((ExpressionTree)tree.expression())) {
                        this.fieldsReadOnAnotherInstance.add(symbol);
                    }
                } else {
                    this.fieldsReadOnAnotherInstance.add(symbol);
                }
            }
            super.visitMemberSelectExpression(tree);
        }
    }
}

